
clear;%clc;
bb=8; % block size
RR=4; % redundancy factor
K=RR*bb^2; % number of atoms in the dictionary
pathForImages ='';
%imageName = {'lena.png' 'barbara.png' 'house.png' 'peppers256.png' 'boat.png'};
imageName = {'house.png'};
sigmatest=[5 30;
           10 50;
           15 75;
];
r1_truetest=[0.3 0.5 0.7];
jj=1;
for fignum=1:length(imageName)
[IMin0,pp]=imread(strcat([pathForImages,imageName{fignum}]));
IMin0=im2double(IMin0);
if (length(size(IMin0))>2)
    IMin0 = rgb2gray(IMin0);
end
if (max(IMin0(:))<2)
    IMin0 = IMin0*255;
end

for signum=1:size(sigmatest,1)
        for rnum=3:3;1:length(r1_truetest)
sigma_1 = sigmatest(signum,1);
sigma_2=  sigmatest(signum,2);
r1true=r1_truetest(rnum);
r2true=1-r1true;
randn('seed',2000);
n1=sigma_1*randn(round(numel(IMin0)*r1true),1);
n2=sigma_2*randn(numel(IMin0)-round(numel(IMin0)*r1true),1);
%n2=[repmat(-1000,[round((numel(IMin0)-round(numel(IMin0)/2))/2) 1]);...
%    repmat(1000,[numel(IMin0)-round(numel(IMin0)/2)-round((numel(IMin0)-round(numel(IMin0)/2))/2) 1])];
n=[n1;n2];
rand('seed',2000);
ind=randperm(numel(n));
ind1=ind(1:length(n1));
ind2=ind(length(n1)+1:end);
n(ind)=n;
IMin=IMin0+reshape(n,size(IMin0));
%IMin=IMin0;
%IMin(IMin>255)=255;
%IMin(IMin<0)=0;
u=repmat(1,size(IMin0));
%u(ind2)=1;
I_ext=padarray(IMin,[1 1],'symmetric');
Ix=I_ext(3:end,2:end-1)-I_ext(2:end-1,2:end-1);
Ixx=I_ext(3:end,2:end-1)+I_ext(1:end-2,2:end-1)+I_ext(2:end-1,3:end)+I_ext(2:end-1,1:end-2)-4*I_ext(2:end-1,2:end-1);
sumv=var(Ixx(:))/10;
%Thelta.sigma1=sqrt(sumv/26);
%Thelta.sigma2=sqrt(25*sumv/26);
Thelta.sigma2(1)= sumv/4;%sigma_1^2;
Thelta.sigma2(2)= 3*sumv/4;%sigma_2^2; 
Thelta.r(1)=1/2;%r1true;
Thelta.r(2)=1-Thelta.r(1);
%sigma1=100;
%sigma2=5;

%W=~(IMin==255 | IMin==0);W=double(W);
%W=repmat(1/sigma1,size(IMin));
%W=sqrt(u./(sigma1^2)+(1-u)./(sigma2^2));

PSNRIn = 20*log10(255/sqrt(mean((IMin(:)-IMin0(:)).^2)));

[IoutAdaptive,output,res] = denoiseImageWKSVD(IMin,K,Thelta,u,IMin0);
result(jj).imagename=[imageName{fignum}];
result(jj).ratio=[num2str(r1true) ':' num2str(r2true)];
result(jj).truesigma=['sigma1=' num2str(sigma_1) ';' 'sigma2=' num2str(sigma_2)];
result(jj).res=res;
%result(jj).D=output.D;
jj=jj+1
%figure,imshow(IMin,[]);
    end
end
end

save('resultGM.mat','result');
%{
PSNROut = 20*log10(255/sqrt(mean((IoutAdaptive(:)-IMin0(:)).^2)));
figure;
subplot(1,3,1); imshow(IMin0,[]); title('Original clean image');
subplot(1,3,2); imshow(IMin,[]); title(strcat(['Noisy image, ',num2str(PSNRIn),'dB']));
subplot(1,3,3); imshow(IoutAdaptive,[]); title(strcat(['Clean Image by Adaptive dictionary, ',num2str(PSNROut),'dB']));

figure;
I = displayDictionaryElementsAsImage(output.D, floor(sqrt(K)), floor(size(output.D,2)/floor(sqrt(K))),bb,bb);
title('The dictionary trained on patches from the noisy image');
%}