% This is a simple demo for VP-STD softmax.
%By Jun Liu, BNU.
clear; clc;close all;
Ima = imread('./images/test1.png');
Ima = mat2gray(double(Ima));
randn('seed',100);
Ima =imnoise(Ima,'gaussian',0,0.01);



I = 2;  % number of classes.
[M,N,T] = size(Ima);
n = M*N; 
ImaVec = reshape(Ima,[M*N,T]);
[L,~]=kmeans(ImaVec,I,'Start',[0.2;0.8]); %kmean initial value
for i=1:I
    phik=double(L==i);
    phiinit(:,i)=phik;
    phik_area=(sum(phik)+eps);
    mu(:,:,i)=sum(ImaVec.*repmat(phik,[1 T]))./phik_area;
    dm=ImaVec-repmat(mu(:,:,i),[M*N 1]);
    Sigma(:,:,i)=(dm'*(dm.*repmat(phik,[1 T])))./phik_area+eps*eye(T);
    temp(:,i)=0.5*sum(dm.*(dm/Sigma(:,:,i)),2);
end
%feature o
o=reshape(-temp,[M N I]);

epsilon = .05; % entropic parameters.
lambda =10; % regularization parameters 
Maxiter = 300;
k=fspecial('gaussian',5,5.0); %Gaussian kernel of STD
ratio=0.59;%0.25, ratios of volume.
V=[n-round(n*ratio) round(n*ratio)]; % volume
V = reshape(V,[1 1 I]);

%softmax initialization for u
o1=o/epsilon;
o1max=max(o1,[],3);  
o2=exp(bsxfun(@minus,o1,o1max)); % for stabliety of softmax
u=bsxfun(@rdivide,o2,sum(o2,3)+1e-10);
u_softmax=u;

q=repmat(0,[1 1 size(o,3), size(o,4)]);
p=repmat(0,size(o));
u_old=zeros(M,N,I);

for i=1:Maxiter 
   % STD spatial regularization dual step.
   p=lambda*imfilter(1-2*u,k);
   %volume preserving dual step.
   o1=bsxfun(@plus,o-p,q)/epsilon;
   o1max=max(o1,[],3);
   o2=exp(bsxfun(@minus,o1,o1max));
   u=bsxfun(@rdivide,o2,sum(o2,3)+eps);  %softmax for calculating volume.
   q=q+10*epsilon*(log(V+eps)-log(sum(sum(u,1),2)+eps)); %large step size 10 can speed up the converenge.
   %The following softmax step can be skipped to fast implement since there is a softmax u in dual step.
   %{
   o1=bsxfun(@plus,o-p,q)/epsilon;
   o1max=max(o1,[],3);
   o2=exp(bsxfun(@minus,o1,o1max));
   u=bsxfun(@rdivide,o2,sum(o2,3)+eps);
   %}
   error=sum((u(:)-u_old(:)).^2);
   %fprintf('%.4f\n',error);
   if error<3e-2
        break
   end
   u_old=u;
   %show result
   if mod(i,10)==0
   figure(1),
   subplot(121),imshow(Ima,[]);
   hold on
   [~,res]=max(u,[],3);
   contour(res,[1.5 1.5],'b','linewidth',2);
   hold off;
   subplot(122),imshow(u(:,:,2),[]);title(num2str(i));
   drawnow;
   end
end
%Display results.
[maxv,segres]=max(u,[],3);
figure,
subplot(221),imshow(Ima,[]);title('The edges of segmentation');
for i=1:I
hold on,contour(segres,[i i],'g','Linewidth',2);
end
hold off;
subplot(222),imshow(u_softmax(:,:,2)>0.5,[]);title(['softmax']);
subplot(223),imshow(u(:,:,2)>0.5,[]);title(['vp-std']);