%This is a simple demo for STD-softmax
%By Jun Liu, BNU.
clear all;close all;

Ima=repmat(0,[256 256]);
Ima(10:40,120:150)=1;
Ima(40:180,40:180)=1;
Ima(115:145,115:145)=0;
Ima(70:100,150:180)=0;
Ima(200:230,120:150)=1;

randn('seed',0);
Ima=imnoise(Ima,'gaussian',0,(150/255)^2);


[M,N]=size(Ima);
MN=M*N;
I=2;
Maxiter=100;
%Parameters. The final segmentaion results may be effected by these parameters.

epsilon=.1;
lambda =1.0; %regularization parameter, the larger, the smoother.


k=fspecial('gaussian',5,5.0); %Gaussian kernel of STD



%%Kmean initial.
[L kc]=kmeans(Ima(:),I,'start', [0;1]);


for i=1:I
    ui=double(L==i);
    ui_area=(sum(ui)+1e-10);
    mu=sum(Ima(:).*ui)/ui_area;
    dm=Ima(:)-mu;
    temp(:,i)=0.5*sum(dm.*dm,2); % L2-distance
end

% input feature o.
o=reshape(-temp,[M,N,I]); 


%softmax initiation for u
o1=o/epsilon;
o1max=max(o1,[],3);  
o2=exp(bsxfun(@minus,o1,o1max)); % for stabliety of softmax
u=bsxfun(@rdivide,o2,sum(o2,3)+1e-10);

u_softmax=u;




oldu=inf;
for t=1:Maxiter     
       % STD spatial regularization dual step.
       p=lambda*imfilter(1-2*u,k);
       %softmax
       o1=o-p;
       o1=o1/epsilon;
       o1max=max(o1,[],3);
       o2=exp(bsxfun(@minus,o1,o1max));
       u=bsxfun(@rdivide,o2,sum(o2,3)+1e-10);
       
       error=norm(u(:)-oldu(:),'fro')/norm(u(:),'fro');

       %Demo   
       if mod(t,2)==0
       figure(1),
       imshow(u(:,:,2),[]);
       title(num2str(t));
       drawnow;
       fprintf('error=%e\n',error);
       end
       if  error<1e-2 %end condition.
             break;
       end 
       oldu=u;
       
end

%Display results.
[maxv,segres]=max(u,[],3);
figure,
subplot(221),imshow(Ima,[]);title('The edges of segmentation');
for i=1:I
hold on,contour(segres,[i i],'g','Linewidth',2);
end
hold off;
subplot(222),imshow(u_softmax(:,:,2)>0.5,[]);title(['softmax']);
subplot(223),imshow(u(:,:,2)>0.5,[]);title(['std']);
%imwrite(Ima,'o.jpg');
%imwrite(u_softmax(:,:,2)>0.5,'softmax.png');
%imwrite(u(:,:,2)>0.5,'std.png');


