%This is a simple demo for SS-STD softmax. By Jun Liu, BNU.
clear all;close all;

Ima=repmat(0,[256 256]);
Ima(10:40,120:150)=1;
Ima(40:180,40:180)=1;
Ima(115:145,115:145)=0;
Ima(70:100,150:180)=0;
Ima(200:230,120:150)=1;


randn('seed',0);
Ima=imnoise(Ima,'gaussian',0,(150/255)^2);


[M,N]=size(Ima);
MN=M*N;
I=2;
Maxiter=5000;
%Parameters. The final segmentaion results may be effected by these parameters.

epsilon=1;
lambda =1.0*epsilon; %regularization parameter, the larger, the smoother.
tauq=1.0*epsilon;


starnum=2;
delta=repmat(0,[1,I]);
delta(starnum)=1.0;
delta=reshape(delta,[1,1,I]);
k=fspecial('gaussian',5,5.0); %Gaussian kernel of STD



%%Kmean initial.
[L kc]=kmeans(Ima(:),I,'start', [0;1]);


for i=1:I
    ui=double(L==i);
    ui_area=(sum(ui)+1e-10);
    mu=sum(Ima(:).*ui)/ui_area;
    dm=Ima(:)-mu;
    temp(:,i)=0.5*sum(dm.*dm,2); % L2-distance
end

% input feature o.
o=reshape(-temp,[M,N,I]); 


%softmax initiation for u
o1=o/epsilon;
o1max=max(o1,[],3);  
o2=exp(bsxfun(@minus,o1,o1max)); % for stability of softmax
u=bsxfun(@rdivide,o2,sum(o2,3)+1e-10);

u_softmax=u;
% dual variable of star shape.
q=repmat(0,[M N]);

%center of star shape
cx=114;%58; 
cy=226;%140; 
%{
figure(1),imshow(Ima,[]);
[cy,cx]=ginput(1);
close all;
%}
[y,x]=meshgrid(1:M,1:N);
sx=cx-x;
sy=cy-y;
sn=sqrt(sx.^2+sy.^2)+1e-10;
sx=sx./sn;
sy=sy./sn;



oldu=inf;
for t=1:Maxiter     

       % star shape dual step
       [ux,uy]=mygradient(u(:,:,starnum));
       q=q-tauq*(ux.*sx+uy.*sy);
       q=max(q,0);
       sp=mydiv(sx.*q,sy.*q);
       % STD spatial regularization dual step.
       p=lambda*imfilter(1-2*u,k);
       %softmax
       o1=o-p-bsxfun(@times,delta,sp);
       o1=o1/epsilon;
       o1max=max(o1,[],3);
       o2=exp(bsxfun(@minus,o1,o1max));
       u=bsxfun(@rdivide,o2,sum(o2,3)+1e-10);
       
       error=norm(u(:)-oldu(:),'fro')/norm(u(:),'fro');

       %Demo   
       if mod(t,100)==0
       figure(1),
       imshow(u(:,:,2),[]);
       hold on;
       plot(cy,cx,'ro','MarkerFaceColor','r');
       hold off;
       title(num2str(t));
       drawnow;
       fprintf('error=%e\n',error);
       end
       if  error<2e-5 %end condition.
             break;
       end 
       oldu=u;
       
end

%Display results.
[maxv,segres]=max(u,[],3);
figure,
subplot(221),imshow(Ima,[]);title('The edges of segmentation');
for i=1:I
hold on,contour(segres,[i i],'g','Linewidth',2);
end
plot(cy,cx,'ro');
hold off;
subplot(222),imshow(u_softmax(:,:,starnum)>0.5,[]);title(['softmax']);
subplot(223),imshow(u(:,:,starnum)>0.5,[]);title(['star shape']);
hold on;
plot(cy,cx,'ro','MarkerFaceColor','r');
hold off;
%res=getframe(gca)
%res=frame2im(res);
%imwrite(res,'star1.png');
