%A comparison of between Ishikawa's and proposed.
clear all;
Im=imread('hills.jpg');
Im=Im(:,:,1);
Im=mat2gray(Im);
height= size(Im,1);
width=size(Im,2);
depth=size(Im,3);
N = height*width;

K=4; % number of clusters.

lambda=1.0e-1;
epsilon=1.e-6;


E = edges4connected(height,width,K);
%V =1.0./(1.0+(mm(E(:,1))-mm(E(:,2))).^2);
V=repmat(1,[size(E,1),1]);
S = sparse(E(:,1),E(:,2),lambda*V,(K-1)*N,(K-1)*N,4*(K-1)*N);


m={};
for k=1:K
    m{k}=repmat((max(Im(:))-min(Im(:)))/(K+1)*k,[1 1 depth]);
end

resold=repmat(0,[(K-1)*N 1]);
for iter=1:500
for k=1:K
     tempf=sum((Im-repmat(m{k},[height width])).^2,3);
    f(:,k)=tempf(:);
end
T=sparse(f);

tic;
[flow,res] = maxflowmex_Ishikawa(S,T);
t1(iter)=toc;


tic;
[flow1,res1] = maxflowmex_proposed(S,T);
t2(iter)=toc;

phi=reshape(res,[height width K-1]);
phi1=reshape(res1,[height width K-1]);

Lab=sum(phi,3);
Lab1=sum(phi1,3);

for k=1:K
   m{k}=sum(sum(Im.*repmat(double(Lab==(k-1)),[1 1 depth]),1),2)/sum(sum(double(Lab==(k-1))));
end


if sum((resold-double(res)).^2)<sum(double(res).^2)*epsilon
    break;
end
resold=double(res);

end


figure,subplot(121),imshow(Lab,[]);
subplot(122),imshow(Lab1,[]);
fprintf('The average CPU time of Ishikawa graph cut %f \n',mean(t1));
fprintf('The average CPU time of Proposed graph cut %f \n',mean(t2));

