%implemenation of the simplified continuous max-flow.
clc;
clear;
close all;

filename={'../Images/hills.jpg'}

for filenum=1:length(filename)
Im=imread(filename{filenum});
if filenum==1
Im=Im(:,:,1);
end;

Im=mat2gray(Im);
height= size(Im,1);
width=size(Im,2);
depth=size(Im,3);
N = height*width;

if filenum==1
K=4; % number of clusters
lambda=2e-1;
elseif filenum==2
    K=3;
    lambda=2e-1;
end

epsilon=1.e-6;
delta1=1;
delta2=.1;


m={};
for k=1:K
    m{k}=repmat((max(Im(:))-min(Im(:)))/(K+1)*k,[1 1 depth]);
end


phi=repmat(0,[height width K-1]);
phiold=phi;
p1=repmat(0,[height width K]);
p2=p1;

 f=repmat(0,[height width K]);
for iter=1:1000
    for k=1:K
      f(:,:,k)=sum((Im-repmat(m{k},[height width])).^2,3);
    end
    divp=mydiv(p1,p2);
    %updating supper-level set functions phi. 
    for k=1:K-1
    phi(:,:,k)=phi(:,:,k)-delta1*(f(:,:,k+1)-f(:,:,k)+(divp(:,:,k+1)-divp(:,:,k)));
    end
     phi=ProjectionPhimex(phi,[height width K-1]);%Projections.
    [phix,phiy]=mygradient(phi);
    %updating dual variable.
    p1=p1-delta2*phix;
    p2=p2-delta2*phiy;
    [p1,p2]=Proj(p1,p2,lambda); % Projections.
    
    %updating means.
    if mod(iter,30)==0
     u(:,:,1)=1-phi(:,:,1);
    for k=2:K-1
    u(:,:,k)=phi(:,:,k-1)-phi(:,:,k); 
    end
    u(:,:,K)=phi(:,:,K-1);
    for k=1:K
       m{k}=sum(sum(Im.*repmat(u(:,:,k),[1 1 depth]),1),2)/sum(sum(u(:,:,k)));
    end
    end
    
    
    if mod(iter,10)==0
    figure(1)
    for fg=1:K-1
    subplot(1,K-1,fg),imshow(phi(:,:,fg),[]);
    title(['\Phi_' num2str(fg)]);
    end
    text(width/2,height+40,['Iter=' num2str(iter)]);
    end
    n=phi-phiold;
    if (sum(sum(sum(n.*n,1),2),3)<epsilon*sum(sum(sum(phiold.*phiold,1),2),3));
        break;
    end
    phiold=phi;
end


phi(find(phi>=0.5))=1.0;
phi(find(phi<0.5))=0;
 u(:,:,1)=1-phi(:,:,1);
    for k=2:K-1
    u(:,:,k)=phi(:,:,k-1)-phi(:,:,k); 
    end
    u(:,:,K)=phi(:,:,K-1);


res=repmat(0,size(Im));


figure,
for fg=1:K
subplot(2,ceil(K/2)+1,fg+2),imshow(u(:,:,fg),[]); 
res=res+repmat(m{fg},[height width 1]).*repmat(u(:,:,fg),[1 1 depth]);
if fg==K
    subplot(2,ceil(K/2)+1,1),imshow(Im,[]);
    title('Images');
    subplot(2,ceil(K/2)+1,2),imshow(res,[]);
    title('result');
end
end

Lab=zeros(height,width);
for k=1:size(u,3)
    Lab=Lab+k*u(:,:,k);
end
figure,imshow(Lab,[]);
title('labels');
if size(res,3)==1
Labres=cat(3,res,res,res);
else size(res,3)==3
  Labres=res;
end

if filenum==1
    cx=30;
    cy=435;
elseif filenum==2
    cx=59;
    cy=268;
end

for i=0:31
    for j=0:3
Labres(cx-16+i,cy-16+j,:)=[255 0 0];
Labres(cx-16+i,cy+15+j,:)=[255 0 0];
Labres(cx-16+j,cy-16+i,:)=[255 0 0];
Labres(cx+15+j,cy-16+i,:)=[255 0 0];
    end
end
Lablocal=res(cx-16:cx+15,cy-16:cy+15,:);

imwrite(Labres,['exp2_' num2str(filenum) 'duallab.bmp']);
imwrite(Lablocal,['exp2_' num2str(filenum) 'duallab_local.bmp']);

end
