/***********************************************************/
/****** Projection on 1>=phi_1>=phi_2>=...>=phi_K>=0********/
/***********************************************************/
/* By J.Liu, Aug. 2012 */


#include <stdio.h>
#include <stdlib.h>
#include <mex.h>
#include <math.h>

#define X(i,j,k) (k)*MN+(j)*M+(i)
#define MAX(a,b) ( a > b ? a : b )
#define MIN(a,b) ( a < b ? a : b )

/****************************************/
extern void mexFunction(int iNbOut, mxArray *pmxOut[],
int iNbIn, const mxArray *pmxIn[])
{

  /* iNbOut: number of outputs
     pmxOut: array of pointers to output arguments */

  /* iNbIn: number of inputs
     pmxIn: array of pointers to input arguments */


    double *pfphi,*pfparameters,*pfproj; 
    int M, N, K, MN, iNdim,iDim[3],*Dim;
    int i,j,k,k1,k2;
    double num;
    double current,next,previous,temp;
    /* Inputs */
    pfphi   = mxGetData(pmxIn[0]); /*input: phi*/
    pfparameters =mxGetData(pmxIn[1]);
    M= (int) pfparameters[0];
    N= (int) pfparameters[1];
    K= (int) pfparameters[2];
    MN=M*N;
    /* Outputs */
    iNdim = 3;
    iDim[0] = M;
    iDim[1] = N;
    iDim[2] = K;
    pmxOut[0] = mxCreateNumericArray(iNdim,(const int*)iDim,mxDOUBLE_CLASS,mxREAL);
    pfproj = mxGetData(pmxOut[0]);
     for (j=0;j<N;j++)
      for (i=0;i<M;i++)
	  for (k=0;k<K;k++)
          pfproj[X(i,j,k)]=pfphi[X(i,j,k)];
     
     for (j=0;j<N;j++)
      for (i=0;i<M;i++)
	{ 
	  for (k=0;k<K-1;k++)
	  {  
		  num=2.0;
              current=pfproj[X(i,j,k)];
		  next=pfproj[X(i,j,k+1)];
	     if (current<next)
	     {  
		  temp=pfphi[X(i,j,k)]+pfphi[X(i,j,k+1)];
	        pfproj[X(i,j,k)]=temp/num;
	//	  pfproj[X(i,j,k+1)]=temp/num;
		 for (k1=k;k1>0;k1--)
		  {
		    previous=pfproj[X(i,j,k1-1)];
		    current=pfproj[X(i,j,k1)];
		    if (previous<current)
		    { 
			 temp+=pfphi[X(i,j,k1-1)];
			 num+=1.0;
			 pfproj[X(i,j,k1-1)]=temp/num;

		    }
		    else 
			    break;
		   }
		   for (k2=k1;k2<=k+1;k2++)
                  pfproj[X(i,j,k2)]=temp/num;
	     }
 
	  }
	  for (k=0;k<K;k++)
	  {
	    pfproj[X(i,j,k)]=MAX(MIN(pfproj[X(i,j,k)],1.0),0.0);
	  }

    } //end for (j=0;j<N;j++)

}
  




