clc;
clear;

imagename={'gray1.bmp'  'gray2.bmp' 'color1.jpg' 'color2.bmp' 'color3.bmp'...
    'color4.bmp' 'paper.bmp'};

isgray=[1 1 0 0 0 0 0];
clusternum=[2 4 2 2 4 5 3];

for inum=1:length(imagename)

Ima=imread(imagename{inum});
Ima=imnoise(Ima,'gaussian',0,(10/255)^2);
%Ima=imresize(Ima,0.5);
if isgray(inum)
Ima=Ima(:,:,1);
end

Ima=double(Ima);
[M N H]=size(Ima);
MN=M*N;
K=clusternum(inum); % the numbers of clusters.
Maxiter=500;
for i=1:H
    Temp=Ima(:,:,i);
    u(:,i)=Temp(:);
end


%%Kmean initial.

[L kc]=kmeans(u,K);
for k=1:K
    phik=double(L==k);
    phiinit(:,k)=phik;
    phik_area=(sum(phik)+eps);
    mu(k,:)=sum(u.*repmat(phik,[1 H]))./phik_area;
    dm=u-repmat(mu(k,:),[MN 1]);
   % Sigma(:,:,k)=(dm'*(dm.*repmat(phik,[1 H])))./phik_area+eps*eye(H);
    Sigma(:,:,k)=50^2*eye(H);
    alpha(k)=1/K;
end

% Other initial values for \mu.
if strcmpi(imagename{inum},'paper.bmp')
mu(1,:)=[255 0 0];
mu(2,:)=[ 0 255 0];
mu(3,:)=[0 0 255];
end


phi=single(phiinit);
PHI=reshape(phi,[M N K]);
V=PHI;
d=zeros(M,N,K);

%Parameters. The final segmentaion results may be effected by these parameters.
lambda =1e-0;%8e-4;%1e-0; %regularization parameter, the larger, the smoother.
Beta =lambda*10;%lambda*2;%lambda*10;% Penalty parameter in Bregman iteration.
eta=1e-0; %1e-4;%1e-0;   % Penalty parameter.

VecParameters = [M;N;K;lambda;Beta];
oldV=repmat(1,[M N K]);
for i=1:Maxiter
      
      % smooth E-step. 
   
       phi=EStep_smooth(u,alpha,mu,Sigma,eta*d);
      % M-step.
       [alpha,mu,Sigma]=MStep(phi,u);
       PHI=reshape(phi,[M,N,K]); 
    
      % TV-step. 
       V=SBIVTV_mex(single(-eta*d),single(VecParameters),single(V));    
      % Dual-step.
      d=(PHI-V)./(max(max(sqrt(sum((PHI-V).^2,3))))+eps); % more stable by using this one.
   
      %Demo   
       if mod(i,1)==0
       figure(1),
       [res1 res2]=max(V,[],3);
       imshow(res2,[]);
       title(num2str(i));
       end
       if norm(V(:)-oldV(:),'fro')/norm(V(:),'fro')<1e-3 %end condition.
           break;
       end          
     oldV=V;
         
end

%Display results.
[maxv,segres]=max(V,[],3);

figure,
subplot(221),imshow(uint8(Ima),[]);title('The edges of the clusters');
for k=1:K
hold on,contour(segres,[k k],'r','Linewidth',2);
end
hold off;
subplot(222),imshow(segres,[]);title(['The' num2str(K) '-label function']);
res=repmat(0,[M N H]);
for k=1:K
    cor=repmat(reshape(mu(k,:),[1 1 H]),[M N 1]);
    ind=find(segres==k);
    res1=cor.*repmat(double(segres==k),[1 1 H]);
    res=res+res1; 
end
subplot(223),imshow(uint8(res));
title(['The segmented piecewise images (K=' num2str(K) ')']);
%imwrite(uint8(res),[num2str(inum) '.bmp']);
%imwrite(uint8(Ima),[num2str(inum) 'noisy.bmp']);
clear u phiinit mu Sigma alpha;

end