% A simple demo for convex shape STD sigmoid segmentation.
%Jun Liu. BNU. 2020-2-10.
clear; clc;
I=imread('test.png');
I=mat2gray(I);
randn('seed',0);
I=imnoise(I,'gaussian',0,0.05);
[hei,wid,dep]=size(I);
Numclass=2;
mu=repmat(0,[1,1,dep,Numclass]);
for k=1:Numclass
    mu(:,:,:,k)=1/(2*Numclass)+(k-1)/Numclass;
end
Maxiter = 10;
e=1.0;% weighting function for image edges.
epsilon = 0.05; % entropy parameter. Should be small.
lambda =10; % regularization parameter.
G_size=7;
sigma=5.0;
R=[15,10,5,3,1]; % sphere radius

o_hat= -sum(bsxfun(@minus,I,mu).^2,3); % features.
o=o_hat(:,:,1)-o_hat(:,:,2); %differnece of features.

%initialization
u_sigmoid=1./(1+exp(-o/epsilon));
u=u_sigmoid;
G_sigma=fspecial('gaussian',[G_size,G_size],sigma);



for i=1:Maxiter 
% STD dual step    
p=e.*imfilter(1-u,G_sigma,'symmetric')-imfilter(e.*u,G_sigma,'symmetric');
%sigmoid
u=1./(1+exp((-o+lambda*p)./epsilon));

% convex constraint
for j=0:50
K=fspecial('disk',R(mod(j,5)+1));    
%active set      
flag=double((1-u).*imfilter(1-2*u,K,'replicate',0)<0);
%update u
u=flag+(1-flag).*u;
end

if mod(i,2)==0
    figure(1),
    imshow(I);
    hold on
    contour(u,[0.5 0.5],'b','linewidth',2);
    hold off;
    title(num2str(i))
    drawnow;
end
end
figure(2),imshow(u);
%{
 figure(1),
 imshow(I);
 hold on
 contour(u,[0.5 0.5],'b','linewidth',2);
 hold off;
 %}
 %imwrite(I,'image.png');
 %imwrite(u,'u_STD.png');
 %imwrite(u_sigmoid,'u_sigmoid.png');