%A demo for the experiment 4 in the paper.
clc;
clear;
pathname='Images/';
filename={'lung.jpg','brain.tif','ultrasound.jpg','cameraman.gif '};
for cpt=1:length(filename)
 switch cpt
     case 1
     parameters=[1e-2,.15,7,50,3.0,2,2];
     case 2
       parameters=[1e-2,.1,3,50,3.0,2,2];
     case 3
      parameters=[1e-2,.1,7,50,3.0,2,2];  
     case 4
      parameters=[1e-2,.1,3,50,3.0,2,2];
 end
Img=imread([pathname filename{cpt}]);
Img=double(Img(:,:,1));
img=mat2gray(Img); 
u=IEWCVT_fasttwophase(img,parameters);
figure(cpt),
subplot(221),imshow(img);title('original');
subplot(222),imshow(u,[]);title('Label function');
subplot(223),imshow(img);title('contour');
hold on;
contour(u,[0 0],'g','Linewidth',2);
hold off;
end
