%A demo for the experiment 2 in the paper.
clc;clear;
for i=1:6
cpt=i;%select a image. cpt=1,2,3,4. corresponding to 1.bmp,2.bmp,3.bmp,4.bmp.

pathname='Images/';
filename=[num2str(cpt) '.bmp'];

Ima=imread([pathname filename]);
img=mat2gray(Ima(:,:,1));
switch cpt
    case 1,
       NumTiles=[2 2];
       cliplimit=0.001;
       parameters=[1.0,1e-2,1.0,3,50,3.0,3,2];   %[\beta,\epsilon,\lambda,\omega,maxiter,\sigma,cvtiter,M]
       parametersEWCVT=[5,0.01,1e-2,50,2,2];
    case 2,
       NumTiles=[2 2];
       cliplimit=0.0005;
       parameters=[0.7,1e-2,1.0,5,50,3.0,3,2];
       parametersEWCVT=[5,0.01,1e-2,50,2,2];
    case 3,
       NumTiles=[2 2];
       cliplimit=0.0005;
       parameters=[1.0,1e-2,1.0,5,50,3.0,3,2]; 
       parametersEWCVT=[5,0.01,1e-2,50,2,2];
    case 4,
       NumTiles=[2 2];
       cliplimit=0.0005;
       parameters=[1.0,1e-2,1.0,5,50,3.0,3,2]; 
       parametersEWCVT=[5,0.01,1e-2,50,2,2];
    case 5,
       NumTiles=[2 2];
       cliplimit=0.2;
       parameters=[1.0,1e-2,1.0,3,50,3.0,3,2];
       %parameters=[1.0,1e-2,1.5,19,50,4.0,3,2]; 
       parametersEWCVT=[3,1.5,1e-2,50,3,2];
     case 6,
       NumTiles=[4 4];
       cliplimit=0.001;
       parameters=[1.1,1e-2,0.01,3,50,1.0,5,3];
       parametersEWCVT=[3,0.01,1e-2,50,5,3];
end

if cpt<6
tic;
img_localinfo=adapthisteq(img,'NumTiles',NumTiles,'ClipLimit',cliplimit)-img;
time1=toc;
tic;
img_localinfo=mat2gray(img_localinfo);
u=IEWCVT_inhomogeneity(img,img_localinfo,parameters);
time2=toc;
totaltime=time1+time2;
tic;
u1=EWCVT(img,parametersEWCVT);
time3=toc;
fprintf(['Image name: ' filename ', the image size is %d*%d. \n'],size(img,1),size(img,2));
fprintf('CLAHE: %f seconds\n',time1);
fprintf('segmentation: %f seconds\n',time2); 
fprintf('the total segmentation time with the proposed model is %f seconds\n',totaltime);
fprintf('the segmentation time with EWCVT is %f seconds\n',time3);
fprintf('\n');
figure(cpt),subplot(221),imshow(img,[]);title('Original image f');
subplot(222),imshow(img_localinfo,[]) ;title('h');
subplot(223),imshow(img,[]);title('EWCVT');
hold on;
contour(u1,[0 0],'b');
hold off;
subplot(224),imshow(img,[]);title('Proposed');
hold  on;
contour(u,[0 0],'g');
hold off;
elseif cpt==6
tic;
img_localinfo=adapthisteq(img,'NumTiles',NumTiles,'ClipLimit',cliplimit)-img;
time1=toc;
tic;
img_localinfo=mat2gray(img_localinfo);
u=IEWCVT_mul_inhomogeneity(img,img_localinfo,parameters);
time2=toc;
totaltime=time1+time2;
tic;
u1=EWCVT(img,parametersEWCVT);
time3=toc;
figure(cpt),subplot(221),imshow(img,[]);title('Original image f');
subplot(222),imshow(img_localinfo,[]) ;title('h');
subplot(223),imshow(u1,[]);title('EWCVT');
subplot(224),imshow(u,[]);title('Proposed');
fprintf(['Image name: ' filename ', the image size is %d*%d. \n'],size(img,1),size(img,2));
fprintf('CLAHE: %f seconds\n',time1);
fprintf('segmentation: %f seconds\n',time2); 
fprintf('the total segmentation time with the proposed model is %f seconds\n',totaltime);
fprintf('the segmentation time with EWCVT is %f seconds\n',time3);
fprintf('\n');
end
end