%A demo for the experiment 1 in the paper.
clc;
clear;
cd Images
Img=imread('test1.bmp');
cd ..
Img=Img(:,:,1);
Img=mat2gray(Img);
parameters1=[9,100,1e-2,50,3.0,2,4];% [\omega,\lambda,\epsilon,maxiter,\sigma,cvtiter,M]
parameters2=[9,100,1e-2,50,2,4];
time1=cputime;
l1=IEWCVT_multiphase(Img,parameters1);
time1=cputime-time1;
time2=cputime;
l2=EWCVT(Img,parameters2);
time2=cputime-time2;
fprintf('Image size %d * %d, IEWCVT CPU time=%f; EWCVT time=%f\n',size(Img,1),size(Img,2),time1,time2);
u1=zeros(size(l1));
u2=zeros(size(l2));
u1(l1==0)=0;
u1(l1==1)=0.3;
u1(l1==2)=0.6;
u1(l1==3)=0.9;
u2(l2==0)=0;
u2(l2==1)=0.3;
u2(l2==2)=0.6;
u2(l2==3)=0.9;
figure,imshow(u1);
figure,imshow(u2);
figure,imshow(Img,[]);