#include "CImg.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

using namespace cimg_library;

#define YES 0
#define NO 1

#define X(ix,iy) (iy)*iNx+ (ix)
#define X4(iXNeigh4,i) iXNeigh4 + i
#define X4b(iXinv,i) (i)*iNyx+ iXinv
#define Xe(ix,iy) (iy)*iNxe+ (ix)
#define XWe(ix,iy,i1,i2) ((iy)*iNx+ ix)*isqw2+ (i2)*iw + i1
#define Xd(idx,idy) (idy+iw2)*iw+ (idx+iw2)
#define Xid1(iXsqw2,iXd) iXsqw2 + iXd
#define Xid2(iXNeigh2,i) iXNeigh2 + i
#define XWe2(iXsqw2,iXd) iXsqw2 + iXd  

#define MAX(a,b) ( a > b ? a : b )
#define ABS(x) ( (x) > 0.0 ? x : -(x) )
#define SQR(x) (x)*(x)

#define SWAP(a,b,tmp) tmp=a; a=b; b=tmp


//float SQRT(float number);
template<typename T>
void NLWeights(CImg<T> &Img0, CImgList<T> &W1_Y1_SY, const int im=5,  const int iw=15, 
			   int iNbNeigh=20, const float fh=0.25*0.25, int iIncludeCloseNeigh=1);

template<typename T>
void CVSeg_SBI(CImg<T>& Im0,CImg<T> & u, CImg<T> & Gb, float fMu=1.0e2, float fLambda=1.0f);

template<typename T>
 void LocalWeights(CImg<T> &Img0, CImgList<T> &W1_Y1_SY, const int im=7,const float fh=0.25*0.25);

template<typename T>
void get_level(CImg<T> &img,CImg<T> &U, CImg<T> &dest);

template<typename T>
void ComputeTextureFeature(CImg<T> & Im0, CImg<T> & TextFeat, int ip);
template<typename T>
void ComputeNLEdgeDetector(CImg<T> & Im0, CImg<T> & Edge,CImgList<T> W1);


