#include <mex.h>
#define cimg_display 0
#define cimg_plugin "cimgmatlab.h"
#include"NLMethods.cpp"
//#include "E:\C&C++\CImg\CImg-1.3.4\CImg-1.3.4\CImg.h"
#include <time.h>
using namespace cimg_library;
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{   

	CImg<> img0(prhs[0],true);
	//CImg<> LI(prhs[1],true);
    CImg<> pfVecParameters(prhs[1],true);
	int ip=(int) pfVecParameters[0];
    float epsilon=pfVecParameters[1]; 
    float lambda=pfVecParameters[2];
	int wsize= (int) pfVecParameters[3];
    int maxiter= (int) pfVecParameters[4];
    float sigma= pfVecParameters[5];
	int cvtiter= (int) pfVecParameters[6];
	const int K=2;
	const int wsizeleft= -wsize/2,wsizeright=(wsize+1)/2;
	CImg<>img(img0);
	time_t start_time1, end_time1,
		   start_time2, end_time2,
		   start_time3, end_time3;
	start_time1=clock();
	ComputeTextureFeature(img0,img,ip);
    end_time1=clock();
	mexPrintf("Compute texture feature, time= %.3f sec\n",difftime(end_time1,start_time1)/1000000);
	const int Nx=img.width(),Ny=img.height(),Nz=img.depth(),Nc=img.spectrum();	
	CImgList<float> V(K,1,1,1,Nc,0.0f);
	CImg<float> U(img.width(),img.height(),img.depth(),1,0);
	start_time2=clock();
    CImgList<> gradimg=img0.get_gradient(0,1);
    CImg<float>g(Nx,Ny,Nz);
	cimg_forXYZ(g,x,y,z)
	{
	 float a1=gradimg(0,x,y,z),a2=gradimg(1,x,y,z);
	 float absgrad=std::sqrt(a1*a1+a2*a2);
	 g(x,y,z)=1.0f/(1.0f+absgrad);
	}
	g.normalize(0,1.0);
    end_time2=clock();
	mexPrintf("Compute edge detector, time= %.3f sec\n",difftime(end_time2,start_time2)/1000000);
    //CImgList<float> V1(K,1,1,1,Nc,0.0f);
	//time_t  start_time, end_time;
	start_time3=clock();
	float energy,energy_old;
	energy=10000000000000.0f;
	//initial values for V_k.
    cimg_forC(img,c)
	{ 
		float m,M=img.get_channel(c).max_min(m);
		//float m1,M1=LI.get_channel(c).max_min(m1);
	    for(int k=0;k<K;k++)
		{
	      V(k,0,0,0,c)=m+(M-m)/(float)(K+1)*(float)(k+1);
		 // V1(k,0,0,0,c)=m1+(M1-m1)/(float)(K+1)*(float)(k+1);
		}


	}
	CImg<> U_compute(Nx,Ny,Nz,K,1.0f);
	//Main iteration
	for (int iter=0;iter<maxiter;iter++)
	{   
		energy_old=energy;
	    energy=0.0f;
		//Update Voronoi areas U.
		cimg_forXYZ(img,x,y,z)
		{ 
			if (std::abs(U_compute(x,y,z))>0.01)
		  { 
			 float dist1,dist2;
             float distF1=0.0f,distF2=0.0f;//distF3=0.0f,distF4=0.0f;	 
			 cimg_forC(img,c)
			 {  
			    distF1+=(img(x,y,z,c)-V(0,0,0,0,c))*(img(x,y,z,c)-V(0,0,0,0,c));
				distF2+=(img(x,y,z,c)-V(1,0,0,0,c))*(img(x,y,z,c)-V(1,0,0,0,c));
				//distF3+=(LI(x,y,z,c)-V1(0,0,0,0,c))*(LI(x,y,z,c)-V1(0,0,0,0,c));
				//distF4+=(LI(x,y,z,c)-V1(1,0,0,0,c))*(LI(x,y,z,c)-V1(1,0,0,0,c));
			 }
			 
			 float distR1=0.0f,distR2=0.0f;
			 if (iter>cvtiter)
			 {
              
			  for (int iy=wsizeleft;iy<wsizeright;iy++ )
			    for (int ix=wsizeleft;ix<wsizeright;ix++ )
				 if ((float)(ix*ix+iy*iy)<(float)(wsize*wsize)/4.0f)
				 {
				    int Ix=x+ix,Iy=y+iy;
					if (Ix<0) Ix=-Ix; else if (Ix>Nx-1) Ix= 2*(Nx-1)-Ix;
					if (Iy<0) Iy=-Iy; else if (Iy>Ny-1) Iy= 2*(Ny-1)-Iy;
					if (U(Ix,Iy)!=0)
					distR1+=g(Ix,Iy);
					else
					distR2+=g(Ix,Iy);
				 }
			   }
			   
			  //  dist1=distF1+beta*distF3+lambda*distR1;
			  // 	dist2=distF2+beta*distF4+lambda*distR2;
			  dist1=distF1+lambda*distR1;
			  dist2=distF2+lambda*distR2;
			   if (dist1>dist2)
			   {
				   U(x,y,z)=1;
				   dist1=dist2;
			   }
			   else 
				   U(x,y,z)=0;
		  energy+=dist1;
		 }
		}
		if (iter==cvtiter)
        U_compute=U-U.get_blur(sigma);
	    //Update center V.
		CImgList<float> sumdata(K,1,1,1,Nc,0.0f),area(sumdata);
			            //sumdata1(K,1,1,1,Nc,0.0f); 
		cimg_forXYZC(img,x,y,z,c)
		{
		    int index=(int) U(x,y,z);
            sumdata(index,0,0,0,c)+=img(x,y,z,c);
			//sumdata1(index,0,0,0,c)+=LI(x,y,z,c);
		    area(index,0,0,0,c)+=1.0f;

		}
		for (int m=0;m<K;m++)
		{  
		   for (int c=0;c<Nc;c++)
		   {      
			  V(m,0,0,0,c)=sumdata(m,0,0,0,c)/(area(m,0,0,0,c)+0.000000001);
			//  V1(m,0,0,0,c)=sumdata1(m,0,0,0,c)/(area(m,0,0,0,c)+0.000000001);
		   }
		}
		if (iter>cvtiter)
		{
       // printf("iter=%d, energy=%f\n",iter,energy);
		if ((energy-energy_old)*(energy-energy_old)<epsilon*energy_old)
		   break;
		}
	}
	end_time3=clock();
	mexPrintf("Segmentation Time= %.3f sec\n",difftime(end_time3,start_time3)/1000000);
	plhs[0]=U.toMatlab();
	/*
	U.display();
	CImg<> res(img0);
	CImg<float> u(img0.width(),img0.height());
	cimg_forXY(U,x,y)
		u(x,y)=(float) U(x,y);	
	get_level(img0,U,res);
	res.display();
	*/
}
