#include <mex.h>
#define cimg_display 0
#define cimg_plugin "cimgmatlab.h"
#include "CImg.h"
//#define cimg_plugin "/media/Study/C&C++/CImg/CImg-1.3.4/CImg-1.3.4/plugins/cimgmatlab.h"
//#include"/media/Study/C&C++/CImg/CImg-1.3.4/CImg-1.3.4/CImg.h"
using namespace cimg_library;
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{   

	CImg<> img(prhs[0],true);
    CImg<> pfVecParameters(prhs[1],true);
	int wsize= (int) pfVecParameters[0];
	float lambda=pfVecParameters[1];
    float epsilon=pfVecParameters[2]; 
    int maxiter= (int) pfVecParameters[3];
    float sigma= pfVecParameters[4];
	int cvtiter= (int) pfVecParameters[5];
	int K= (int) pfVecParameters[6];
    
	const int wsizeleft= -wsize/2,wsizeright=(wsize+1)/2;
	const int Nx=img.width(),Ny=img.height(),Nz=img.depth(),Nc=img.spectrum();	
	CImgList<float> V(K,1,1,1,Nc,0.0f);
	CImg<float> U(img.width(),img.height(),img.depth(),1,0);
    CImgList<> gradimg=img.get_gradient();
    CImg<float>g(Nx,Ny,Nz);
	cimg_forXYZ(g,x,y,z)
	{
	 float a1=gradimg(0,x,y,z),a2=gradimg(1,x,y,z);
	 float absgrad=std::sqrt(a1*a1+a2*a2);
	 g(x,y,z)=1.0f/(1.0f+absgrad);
	}
	g.normalize(0,1.0);
 
	float energy,energy_old;
	energy=10000000000000.0f;
	//initial values for V_k.
    cimg_forC(img,c)
	{ 
		float m,M=img.get_channel(c).max_min(m);
	    for(int k=0;k<K;k++) 
	      V(k,0,0,0,c)=m+(M-m)/(float)(K+1)*(float)(k+1);
	}

	CImg<>U1(Nx,Ny,Ny,1,1.0);
	//Main iteration
	for (int iter=0;iter<maxiter;iter++)
	{   
		energy_old=energy;
	    energy=0.0f;
		//Update Voronoi areas U.
		cimg_forXYZ(img,x,y,z)
		{ 
		 if (std::abs(U1(x,y,z))>0.01)
		  { 
		    float dist_min=100000000.0f;
		    for (int m=0;m<K;m++)
		    {  
             float dist1=0.0f;
			 
			 cimg_forC(img,c)
			 {  
			    dist1+=(img(x,y,z,c)-V(m,0,0,0,c))*(img(x,y,z,c)-V(m,0,0,0,c));
			 }
			 
			 float dist2=0.0f;
			 if (iter>cvtiter)
			 {
			   for (int iy=wsizeleft;iy<wsizeright;iy++ )
			    for (int ix=wsizeleft;ix<wsizeright;ix++ )
				  if ((float)(ix*ix+iy*iy)<(float)(wsize*wsize)/4.0f)
				 {
				    int Ix=x+ix,Iy=y+iy;
					if (Ix<0) Ix=-Ix; else if (Ix>Nx-1) Ix= 2*(Nx-1)-Ix;
					if (Iy<0) Iy=-Iy; else if (Iy>Ny-1) Iy= 2*(Ny-1)-Iy;
					if (U(Ix,Iy)!=m)
						dist2+=g(Ix,Iy);
					
				 
				 }
			 }
			 float dist=dist1+lambda*dist2;
			 if (dist<dist_min)
			 {
			     dist_min=dist;
				 U(x,y,z)=m;
				
			 }
			 
		  }
		  energy+=dist_min;
		 }
		}
		if (iter==cvtiter)
		U1=U-U.get_blur(sigma);
	    //Update center V.
		CImgList<float> sumdata(K,1,1,1,Nc,0.0f),area(sumdata); 
		cimg_forXYZC(img,x,y,z,c)
		{
		    int index=(int) U(x,y,z);
            sumdata(index,0,0,0,c)+=img(x,y,z,c);
		    area(index,0,0,0,c)+=1.0f;
		}
		for (int m=0;m<K;m++)
		{  
		   for (int c=0;c<Nc;c++)
		   {      
			  V(m,0,0,0,c)=sumdata(m,0,0,0,c)/(area(m,0,0,0,c)+0.000000001);
		   }
		}
		
       if (iter>cvtiter)
		{
        //printf("iter=%d, energy=%f\n",iter,energy);
		if ((energy-energy_old)*(energy-energy_old)<epsilon*energy_old)
		   break;
		}
	}
    plhs[0]=U.toMatlab();
}
