#include <mex.h>
#define cimg_display 0
#define cimg_plugin "cimgmatlab.h"
#include "CImg.h"
#include <time.h>
using namespace cimg_library;
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{   

	CImg<> img(prhs[0],true);
	CImg<> LI(prhs[1],true);
    CImg<> pfVecParameters(prhs[2],true);
	float beta=pfVecParameters[0];
    float epsilon=pfVecParameters[1]; 
    float lambda=pfVecParameters[2];
	int wsize= (int) pfVecParameters[3];
    int maxiter= (int) pfVecParameters[4];
    float sigma= pfVecParameters[5];
	int cvtiter= (int) pfVecParameters[6];
	int K= (int) pfVecParameters[7];
	const int wsizeleft= -wsize/2,wsizeright=(wsize+1)/2;
	//if (isgray) img0.channel(0);
	//img0.normalize(0,1);
	//CImg<>img(img0);
	const int Nx=img.width(),Ny=img.height(),Nz=img.depth(),Nc=img.spectrum();	
	CImgList<float> V(K,1,1,1,Nc,0.0f);
	CImg<float> U(img.width(),img.height(),img.depth(),1,0);
    CImgList<> gradimg=img.get_gradient(0,3);
    CImg<float>g(Nx,Ny,Nz);
	cimg_forXYZ(g,x,y,z)
	{
	 float a1=gradimg(0,x,y,z),a2=gradimg(1,x,y,z);
	 float absgrad=std::sqrt(a1*a1+a2*a2);
	 g(x,y,z)=1.0f/(1.0f+absgrad);
	}
	g.normalize(0,1.0);
    
	//LI.normalize(0,1.0f);
    CImgList<float> V1(K,1,1,1,Nc,0.0f);
   
	
   

	//time_t  start_time, end_time;
	//start_time=clock();
	float energy,energy_old;
	energy=10000000000000.0f;
	//initial values for V_k.
    cimg_forC(img,c)
	{ 
		float m,M=img.get_channel(c).max_min(m);
		float m1,M1=LI.get_channel(c).max_min(m1);
	    for(int k=0;k<K;k++)
		{
	      V(k,0,0,0,c)=m+(M-m)/(float)(K+1)*(float)(k+1);
		  V1(k,0,0,0,c)=m1+(M1-m1)/(float)(K+1)*(float)(k+1);
		}


	}
	CImg<> U_compute(Nx,Ny,Nz,K,1.0f);
	//Main iteration
	for (int iter=0;iter<maxiter;iter++)
	{   
		energy_old=energy;
	    energy=0.0f;
		//Update Voronoi areas U.
		cimg_forXYZ(img,x,y,z)
		{ 
		 if (std::abs(U_compute(x,y,z))>0.01)
		  { 
		    float dist_min=100000000.0f;
		    for (int m=0;m<K;m++)
		    {  
             float distF1=0.0f,distF2=0.0f;
			 
			 cimg_forC(img,c)
			 {  
			    distF1+=(img(x,y,z,c)-V(m,0,0,0,c))*(img(x,y,z,c)-V(m,0,0,0,c));
				distF2+=(LI(x,y,z,c)-V1(m,0,0,0,c))*(LI(x,y,z,c)-V1(m,0,0,0,c));
			 }
			 
			 float distR=0.0f;
			 if (iter>cvtiter)
			 {
			   for (int iy=wsizeleft;iy<wsizeright;iy++ )
			    for (int ix=wsizeleft;ix<wsizeright;ix++ )
				  if ((float)(ix*ix+iy*iy)<(float)(wsize*wsize)/4.0f)
				   {
				    int Ix=x+ix,Iy=y+iy;
					if (Ix<0) Ix=-Ix; else if (Ix>Nx-1) Ix= 2*(Nx-1)-Ix;
					if (Iy<0) Iy=-Iy; else if (Iy>Ny-1) Iy= 2*(Ny-1)-Iy;
					if (U(Ix,Iy)!=m)
						distR+=g(Ix,Iy); 
				    }
			 }
            
			 float dist=distF1+beta*distF2+lambda*distR;
			 if (dist<dist_min)
			 {
			     dist_min=dist;
				 U(x,y,z)=m;
				
			 }
			 
		  }
		  energy+=dist_min;
		 }
		}
		if (iter==cvtiter)
        U_compute=U-U.get_blur(sigma);
	    //Update center V.
		CImgList<float> sumdata(K,1,1,1,Nc,0.0f),area(sumdata),
			            sumdata1(K,1,1,1,Nc,0.0f); 
		cimg_forXYZC(img,x,y,z,c)
		{
		    int index=(int) U(x,y,z);
            sumdata(index,0,0,0,c)+=img(x,y,z,c);
			sumdata1(index,0,0,0,c)+=LI(x,y,z,c);
		    area(index,0,0,0,c)+=1.0f;

		}
		for (int m=0;m<K;m++)
		{  
		   for (int c=0;c<Nc;c++)
		   {      
			  V(m,0,0,0,c)=sumdata(m,0,0,0,c)/(area(m,0,0,0,c)+1e-10);
			  V1(m,0,0,0,c)=sumdata1(m,0,0,0,c)/(area(m,0,0,0,c)+1e-10);
		   }
		}
		if (iter>cvtiter)
		{
       // printf("iter=%d, energy=%f\n",iter,energy);
		if ((energy-energy_old)*(energy-energy_old)<epsilon*energy_old)
		   break;
		}
	}
	//end_time=clock();
	//mexPrintf("CVT Segmentation Time= %.3f sec\n",difftime(end_time,start_time)/1000);
	plhs[0]=U.toMatlab();
	/*
	U.display();
	CImg<> res(img0);
	CImg<float> u(img0.width(),img0.height());
	cimg_forXY(U,x,y)
		u(x,y)=(float) U(x,y);	
	get_level(img0,U,res);
	res.display();
	*/
}
