//  weights updating.


#include <stdio.h>
#include <stdlib.h>
#include <mex.h>
#include <math.h>


 
#define YES 0
#define NO 1

#define X(ix,iy) (iy)*iNx+ (ix)
#define Xe(ix,iy) (iy)*iNxe+ (ix)
#define XW(ix,iy,i)  (i)*iNxy+(iy)* iNx+(ix)
#define XWe(ix,iy,i1,i2) (i2)*iNxyw+(i1)*iNxy+(iy)*iNx+(ix)
#define Xd(idx,idy) (idy+iw2)*iw+ (idx+iw2)
#define XG(imx,imy) (imy+im2)*im+(imx+im2)



                    

#define ABS(x) ( x >= 0.0 ? x : -x )
#define SQR(x) (x)*(x)

#define SWAP(a,b,tmp) tmp=a; a=b; b=tmp

#define EPS 0.000000001

static union
{
  double d;
  struct {
// #ifdef LITTLE_ENDIAN
    int j,i;
// #else
//     int i,j;
// #endif
  } n;
} _eco;
#define EXP_A (1048576/0.69314718055994530942)
#define EXP_C 60801
#define DEXP(y) (_eco.n.i = EXP_A*(y) + (1072693248 - EXP_C), _eco.d)
#define EXP(y) (float)DEXP(y)



float SQRT(float number) {
    long i;
    float x, y;
    const float f = 1.5F;
    
    x = number * 0.5F;
    y  = number;
    i  = * ( long * ) &y;
    i  = 0x5f3759df - ( i >> 1 );
    y  = * ( float * ) &i;
    y  = y * ( f - ( x * y * y ) );
    y  = y * ( f - ( x * y * y ) );
    return number * y;
}











        



/****************************************/
extern void mexFunction(int iNbOut, mxArray *pmxOut[],
int iNbIn, const mxArray *pmxIn[])
{
    
  /* iNbOut: number of outputs
     pmxOut: array of pointers to output arguments */
    
  /* iNbIn: number of inputs
     pmxIn: array of pointers to input arguments */
    
    
    float   *pfIm0, *pfVecGeneralParameters, *pfW,*pfG;;
    float   *pfW2, *pfW2b, fh;
    float   *pfIm0e, fDif, fDist,fDistsum, *pfWe;
    float   fcurrent, fTmp;
    float   fWSum;
    
    
    int     iNy, iNx, iNdim, iDim[3];
    int     iNbNeigh, iN3, im, im2, iw, iw2, ic2;
    int     iy, ix, i, iye, ixe,imx,imy,i2, ixt, iyt, iNbBestNeigh;
    int     *piY, iNxy, iNxe, iNye,iNxyw, ik, idx, idy;
    int     iNxye;
    int     istart, iend, imiddle, icurrent, isqw2, iTmp, i3;
    int     *pidx, *pidy, *pidxb, *pidyb, iXd; 
    int     i1a, i1b,iNbNeigh2;
    int     iIncludeCloseNeigh, j1;
    int     iNbNeighToSort, iIsolatedPt;
    short   *psId;
        
    
    
   //input
    pfIm0 = mxGetData(pmxIn[0]);    
    pfVecGeneralParameters = mxGetData(pmxIn[1]);
    pfG=mxGetData(pmxIn[2]);
    
    
    
    iNx = (int) pfVecGeneralParameters[0];
    iNy = (int) pfVecGeneralParameters[1];
    im = (int) pfVecGeneralParameters[2];
    iw = (int) pfVecGeneralParameters[3];
    fh = pfVecGeneralParameters[4];
    iNbNeigh = (int) pfVecGeneralParameters[5];
    iIncludeCloseNeigh = (int) pfVecGeneralParameters[6];
    
    
    im2 = (im-1)/2;
    iw2 = (iw-1)/2;
    ic2 = im2+iw2;
    
    
    if (iNbNeigh>iw*iw-4)
    {
        iNbNeigh = iw*iw;
        iNbBestNeigh = iNbNeigh;
        iIncludeCloseNeigh = NO;
    }
    else
    {
        iNbBestNeigh = iNbNeigh;
        if ( iIncludeCloseNeigh==YES ) iNbNeigh += 4;
    }

    
    iNxy = iNy* iNx;
    iNxyw = iNy*iNx*iw;
    iNxe = iNx + 2* iw2+2*im2;
    iNye = iNy + 2* iw2+2*im2;
    
    
    isqw2 = iw*iw;
    iNxye = iNxe*iNye;
    iNbNeigh2 = 2*iNbNeigh;
    
    
    //output
    iN3 = iNbNeigh* 2;
    iNdim = 3;
    iDim[0] = iNx;   
    iDim[1] = iNy;   
    iDim[2] = iN3;
    pmxOut[0] = mxCreateNumericArray(iNdim,(const int*)iDim,mxSINGLE_CLASS,mxREAL);
    pfW = mxGetData(pmxOut[0]);
    
    
    iN3 =iNbNeigh* 2;
    iNdim = 3;
    iDim[0] = iNx;
    iDim[1] = iNy;
    iDim[2] = iN3;
    pmxOut[1] = mxCreateNumericArray(iNdim,(const int*)iDim,mxINT32_CLASS,mxREAL);
    piY = mxGetData(pmxOut[1]);
    

    
    pfW2 = (float *) calloc( (unsigned)(iw*iw), sizeof(float) );
    if (!pfW2)
        mexPrintf("Memory allocation failure\n");
    
    pfW2b = (float *) calloc( (unsigned)(iNbNeigh), sizeof(float) );
    if (!pfW2b)
        mexPrintf("Memory allocation failure\n");
    
    pidx = (int *) calloc( (unsigned)(iw*iw), sizeof(int) );
    if (!pidx)
        mexPrintf("Memory allocation failure\n");
    
    pidy = (int *) calloc( (unsigned)(iw*iw), sizeof(int) );
    if (!pidy)
        mexPrintf("Memory allocation failure\n");
    
    pidxb = (int *) calloc( (unsigned)(iNbNeigh), sizeof(int) );
    if (!pidxb)
        mexPrintf("Memory allocation failure\n");
    
    pidyb = (int *) calloc( (unsigned)(iNbNeigh), sizeof(int) );
    if (!pidyb)
        mexPrintf("Memory allocation failure\n");
    
    
    psId = (short *) calloc( (unsigned)(iw*iw), sizeof(short) );
    if (!psId)
        mexPrintf("Memory allocation failure\n");
    
    
    pfIm0e = (float *) calloc( (unsigned)(iNxe*iNye), sizeof(float) );
    if (!pfIm0e)
        mexPrintf("Memory allocation failure\n");
    
    pfWe = (float *) calloc( (unsigned)(iNx*iNy*iw*iw), sizeof(float) );
    if (!pfWe)
        mexPrintf("Memory allocation failure\n");
    
    
    

    // init
    for (i=0; i< iNxy; i++)
    {
        j1 = i*iNbNeigh2;
        for (i2=0; i2< iNbNeigh2; i2++) { pfW[j1+i2] = 0.0; piY[j1+i2] = 0; }
    }
    

    
    
    
    
    
    // compute extended image
    for (iye=0,ik=0;iye<iNye;iye++)
        {
            if (iye<ic2)  iy=ic2-iye;
            else if (iye>iNy+ic2-1) iy=2*iNy+ic2-iye-2;
            else iy=iye-ic2;
    for (ixe=0;ixe<iNxe;ixe++,ik++)
    {
        if (ixe<ic2) ix=ic2-ixe;
        else if (ixe>iNx+ic2-1) ix=2*iNx+ic2-ixe-2;
        else ix=ixe-ic2;
        pfIm0e[ik]=pfIm0[X(ix,iy)];
        }
    }
 
    
    for (idy=-iw2;idy<=iw2;idy++)  //Searching window.
        for (idx=-iw2;idx<=iw2;idx++)
        {
              for (iye=ic2;iye<iNye-ic2;iye++) // x
                 for (ixe=ic2;ixe<iNxe-ic2;ixe++)  
                 {
                      ix=ixe-ic2;
                      iy=iye-ic2;
                      ixt=ixe+idx;
                      iyt=iye+idy;
                      fDistsum=0.0f;
                      for(imx=-im2;imx<=im2;imx++) // image patch.
                          for(imy=-im2;imy<=im2;imy++)
                          {
                              
                             fDif= pfIm0e[Xe(ixe+imx,iye+imy)]-pfIm0e[Xe(ixt+imx,iyt+imy)]; 
                            
                             fDist=fDif*fDif*pfG[XG(imx,imy)];
                             fDistsum+=fDist;
                          }
                         
                     pfWe[XWe(ix,iy,idx+iw2,idy+iw2)] = fDistsum;
                 }
             
        }
    
    

          
    // CENTER
    for (iy=ic2; iy< iNy-ic2; iy++)
        for(ix=ic2; ix< iNx-ic2; ix++)
    {
        for (idy=-iw2; idy<= iw2; idy++)
            for(idx=-iw2; idx<= iw2; idx++)
        {
                iXd = Xd(idx,idy);
                pfW2[iXd]=pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
                pidx[iXd] = idx; 
                pidy[iXd] = idy;
            }
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            idx = 1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = -1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = 1; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = -1; pfW2[Xd(idx,idy)] = 0.0;
            iNbNeighToSort = iNbNeigh;
        }
        else        
            iNbNeighToSort = iNbBestNeigh;
        
        
        for (i2=0; i2< iNbNeighToSort; i2++)  pfW2b[i2] = 1024.0;
        for (i2=0; i2< isqw2; i2++)
        {
            fcurrent = pfW2[i2];
            if ( fcurrent<pfW2b[iNbNeighToSort-1] )
            {
                // dichotomy
                istart = 0;
                iend = iNbNeighToSort-1;
                while ( iend-istart>1 )
                {
                    imiddle = (iend-istart)/2;
                    if (pfW2b[istart+imiddle] > fcurrent)
                        iend = istart+imiddle;
                    else
                        istart = istart+imiddle;
                }
                if (pfW2b[istart] > fcurrent)
                    icurrent = istart;
                else
                    icurrent = iend;
                
                // shifting
                for(i3=iNbNeighToSort-2; i3>=icurrent; i3--)
                {
                    SWAP(pfW2b[i3],pfW2b[i3+1],fTmp);
                    SWAP(pidxb[i3],pidxb[i3+1],iTmp);
                    SWAP(pidyb[i3],pidyb[i3+1],iTmp);
                }
                
                // new value
                pfW2b[icurrent] = fcurrent;
                pidxb[icurrent] = pidx[i2];
                pidyb[icurrent] = pidy[i2];
                
            }
        } // end for (i2=0; i2< isqw2; i2++)
        
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            icurrent = 0;
            idx = 0; idy = 0; pfW2b[icurrent] = pfW2b[1+4]; // give same weight to x,y and Yx,Yy
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = 1; idy = 0; pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = -1; idy = 0; pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = 0; idy = 1; pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = 0; idy = -1; pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy;
        }
        else
            pfW2b[0] = pfW2b[1]; // give same weight to x,y and Yx,Yy
        
        
        // compute W
        if ( EXP(-pfW2b[0]/fh)>0.2) iIsolatedPt = 0; else iIsolatedPt = 1;
        for (i=0; i< iNbNeigh; i++)
        {
            idx = pidxb[i];
            idy = pidyb[i];
            i1a=XW(ix,iy,2*i);
            i1b=XW(ix,iy,2*i+1);
             if (iIsolatedPt==0) pfW[i1a] = EXP(-pfW2b[i]/fh); else pfW[i1a] = 0.2;
             pfW[i1b] = SQRT(pfW[i1a]);
             piY[i1a] = ix+idx;
             piY[i1b] = iy+idy;    
        } 
        
        
        } // END
   
    
    
   
    
    // BORDERS
    // BORDER #1
    for (iy=0; iy< ic2; iy++)
        for(ix=0; ix< iNx; ix++)
    {
        for (idy=-iw2; idy<= iw2; idy++)
            for(idx=-iw2; idx<= iw2; idx++)
                if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
        {
            iXd = Xd(idx,idy);
            pfW2[iXd] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 0;
                }
                else
        {
            iXd = Xd(idx,idy);
            pfW2[iXd] = 1024.0;
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 1;
                }
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            idx = 1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = -1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = 1; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = -1; pfW2[Xd(idx,idy)] = 0.0;
            iNbNeighToSort = iNbNeigh;
        }
        else        
            iNbNeighToSort = iNbBestNeigh;
        
        
        for (i2=0; i2< iNbNeighToSort; i2++)  pfW2b[i2] = 1024.0;
        for (i2=0; i2< isqw2; i2++)
        {
            fcurrent = pfW2[i2];
            if ( fcurrent<pfW2b[iNbNeighToSort-1] )
            {
                // dichotomy
                istart = 0;
                iend = iNbNeighToSort-1;
                while ( iend-istart>1 )
                {
                    imiddle = (iend-istart)/2;
                    if (pfW2b[istart+imiddle] > fcurrent)
                        iend = istart+imiddle;
                    else
                        istart = istart+imiddle;
                }
                if (pfW2b[istart] > fcurrent)
                    icurrent = istart;
                else
                    icurrent = iend;
                
                // shifting
                for(i3=iNbNeighToSort-2; i3>=icurrent; i3--)
                {
                    SWAP(pfW2b[i3],pfW2b[i3+1],fTmp);
                    SWAP(pidxb[i3],pidxb[i3+1],iTmp);
                    SWAP(pidyb[i3],pidyb[i3+1],iTmp);
                }
                
                // new value
                pfW2b[icurrent] = fcurrent;
                pidxb[icurrent] = pidx[i2];
                pidyb[icurrent] = pidy[i2];
                
            }
        } // end for (i2=0; i2< isqw2; i2++)
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            icurrent = 0;
            idx = 0; idy = 0; pfW2b[icurrent] = pfW2b[1+4];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = 1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = -1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = 1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = -1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy;}
        }
        else
            pfW2b[0] = pfW2b[1];
        
        // compute W
        if ( EXP(-pfW2b[0]/fh)>0.2 ) iIsolatedPt = 0; else iIsolatedPt = 1;
        for (i=0; i< iNbNeigh; i++)
        {
            idx = pidxb[i];
            idy = pidyb[i];
            iXd = Xd(idx,idy);
            if ( psId[iXd]==0 )
            {
                 i1a = XW(ix,iy,2*i);
                 i1b = XW(ix,iy,2*i+1);
                 if (iIsolatedPt==0) pfW[i1a] = EXP(-pfW2b[i]/fh); else pfW[i1a] = 0.2;
                 pfW[i1b] = SQRT(pfW[i1a]);
                 piY[i1a] = ix+idx;
                 piY[i1b] = iy+idy;
                
                }
            } // end for (i=0; i< iNbNeigh; i++)
        } // END
    

    //mexPrintf("HERE !!!\n");
    
    
    //mexPrintf("HERE 3d\n");
    //mexPrintf("ix= %i, iy = %i, iYx= %i, iYy = %i, i= %i, i2= %i, iNbNeighBorder= %i\n",ix,iy,ix+idx,iy+idy,i,i2,iNbNeighBorder);
    
    
    
    
    
    
    
    
    
    
    
    // BORDER #2
    for (iy=iNy-ic2; iy< iNy; iy++)
        for(ix=0; ix< iNx; ix++)
    {
        for (idy=-iw2; idy<= iw2; idy++)
            for(idx=-iw2; idx<= iw2; idx++)
                if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
        {
            iXd = Xd(idx,idy);
            pfW2[iXd] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 0;
                }
                else
        {
            iXd = Xd(idx,idy);
            pfW2[Xd(idx,idy)] = 1024.0;
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 1;
                }
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            idx = 1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = -1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = 1; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = -1; pfW2[Xd(idx,idy)] = 0.0;
            iNbNeighToSort = iNbNeigh;
        }
        else        
            iNbNeighToSort = iNbBestNeigh;
        
        
        for (i2=0; i2< iNbNeighToSort; i2++)  pfW2b[i2] = 1024.0;
        for (i2=0; i2< isqw2; i2++)
        {
            fcurrent = pfW2[i2];
            if ( fcurrent<pfW2b[iNbNeighToSort-1] )
            {
                // dichotomy
                istart = 0;
                iend = iNbNeighToSort-1;
                while ( iend-istart>1 )
                {
                    imiddle = (iend-istart)/2;
                    if (pfW2b[istart+imiddle] > fcurrent)
                        iend = istart+imiddle;
                    else
                        istart = istart+imiddle;
                }
                if (pfW2b[istart] > fcurrent)
                    icurrent = istart;
                else
                    icurrent = iend;
                
                // shifting
                for(i3=iNbNeighToSort-2; i3>=icurrent; i3--)
                {
                    SWAP(pfW2b[i3],pfW2b[i3+1],fTmp);
                    SWAP(pidxb[i3],pidxb[i3+1],iTmp);
                    SWAP(pidyb[i3],pidyb[i3+1],iTmp);
                }
                
                // new value
                pfW2b[icurrent] = fcurrent;
                pidxb[icurrent] = pidx[i2];
                pidyb[icurrent] = pidy[i2];
                
            }
        } // end for (i2=0; i2< isqw2; i2++)
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            icurrent = 0;
            idx = 0; idy = 0; pfW2b[icurrent] = pfW2b[1+4];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = 1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = -1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = 1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = -1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy;}
            else
            { pfW2b[icurrent] = 1024.0; pidxb[icurrent] = 0; pidyb[icurrent] = 0;}
        }
        else
            pfW2b[0] = pfW2b[1];
        
        // compute W
        if ( EXP(-pfW2b[0]/fh)>0.2 ) iIsolatedPt = 0; else iIsolatedPt = 1;
        for (i=0; i< iNbNeigh; i++)
        {
            idx = pidxb[i];
            idy = pidyb[i];
            iXd = Xd(idx,idy);
            if ( psId[iXd]==0 )
            {
                 i1a = XW(ix,iy,2*i);
                 i1b = XW(ix,iy,2*i+1);
                if (iIsolatedPt==0) pfW[i1a] = EXP(-pfW2b[i]/fh); else pfW[i1a] = 0.2;
                pfW[i1b] = SQRT(pfW[i1a]);
                piY[i1a] = ix+idx;
                piY[i1b] = iy+idy;
              
                } 
            } // end for (i=0; i< iNbNeigh; i++)
        } // END
    
    
    // BORDER #3
    for (iy=ic2; iy< iNy-ic2; iy++)
        for(ix=0; ix< ic2; ix++)
    { 
        for (idy=-iw2; idy<= iw2; idy++)
            for(idx=-iw2; idx<= iw2; idx++)
                if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
        {
            iXd = Xd(idx,idy);
            pfW2[iXd] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 0;
                }
                else
        {
            iXd = Xd(idx,idy);
            pfW2[Xd(idx,idy)] = 1024.0;
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 1;
                }
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            idx = 1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = -1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = 1; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = -1; pfW2[Xd(idx,idy)] = 0.0;
            iNbNeighToSort = iNbNeigh;
        }
        else        
            iNbNeighToSort = iNbBestNeigh;
        
        
        for (i2=0; i2< iNbNeighToSort; i2++)  pfW2b[i2] = 1024.0;
        for (i2=0; i2< isqw2; i2++)
        {
            fcurrent = pfW2[i2];
            if ( fcurrent<pfW2b[iNbNeighToSort-1] )
            {
                // dichotomy
                istart = 0;
                iend = iNbNeighToSort-1;
                while ( iend-istart>1 )
                {
                    imiddle = (iend-istart)/2;
                    if (pfW2b[istart+imiddle] > fcurrent)
                        iend = istart+imiddle;
                    else
                        istart = istart+imiddle;
                }
                if (pfW2b[istart] > fcurrent)
                    icurrent = istart;
                else
                    icurrent = iend;
                
                // shifting
                for(i3=iNbNeighToSort-2; i3>=icurrent; i3--)
                {
                    SWAP(pfW2b[i3],pfW2b[i3+1],fTmp);
                    SWAP(pidxb[i3],pidxb[i3+1],iTmp);
                    SWAP(pidyb[i3],pidyb[i3+1],iTmp);
                }
                
                // new value
                pfW2b[icurrent] = fcurrent;
                pidxb[icurrent] = pidx[i2];
                pidyb[icurrent] = pidy[i2];
                
            }
        } // end for (i2=0; i2< isqw2; i2++)
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            icurrent = 0;
            idx = 0; idy = 0; pfW2b[icurrent] = pfW2b[1+4];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = 1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = -1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = 1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = -1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy;}
        }
        else
            pfW2b[0] = pfW2b[1];
        
        // compute W
        if ( EXP(-pfW2b[0]/fh)>0.2 ) iIsolatedPt = 0; else iIsolatedPt = 1;
        for (i=0; i< iNbNeigh; i++)
        {
            idx = pidxb[i];
            idy = pidyb[i];
            iXd = Xd(idx,idy);
            if ( psId[iXd]==0 )
            {
                  i1a = XW(ix,iy,2*i);
                  i1b = XW(ix,iy,2*i+1);
                  if (iIsolatedPt==0) pfW[i1a] = EXP(-pfW2b[i]/fh); else pfW[i1a] = 0.2;
                  pfW[i1b] = SQRT(pfW[i1a]);
                  piY[i1a] = ix+idx;
                  piY[i1b] = iy+idy;
                
             }
           } // end for (i=0; i< iNbNeigh; i++)
    
        } // END
    
    
    // BORDER #4
    for (iy=ic2; iy< iNy-ic2; iy++)
        for(ix=iNx-ic2; ix< iNx; ix++)
    { 
        for (idy=-iw2; idy<= iw2; idy++)
            for(idx=-iw2; idx<= iw2; idx++)
                if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
        {
            iXd = Xd(idx,idy);
            pfW2[iXd] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)];
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 0;
                }
                else
        {
            iXd = Xd(idx,idy);
            pfW2[Xd(idx,idy)] = 1024.0;
            pidx[iXd] = idx;
            pidy[iXd] = idy;
            psId[iXd] = 1;
                }
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            idx = 1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = -1; idy = 0; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = 1; pfW2[Xd(idx,idy)] = 0.0;
            idx = 0; idy = -1; pfW2[Xd(idx,idy)] = 0.0;
            iNbNeighToSort = iNbNeigh;
        }
        else        
            iNbNeighToSort = iNbBestNeigh;
        
        
        for (i2=0; i2< iNbNeighToSort; i2++)  pfW2b[i2] = 1024.0;
        for (i2=0; i2< isqw2; i2++)
        {
            fcurrent = pfW2[i2];
            if ( fcurrent<pfW2b[iNbNeighToSort-1] )
            {
                // dichotomy
                istart = 0;
                iend = iNbNeighToSort-1;
                while ( iend-istart>1 )
                {
                    imiddle = (iend-istart)/2;
                    if (pfW2b[istart+imiddle] > fcurrent)
                        iend = istart+imiddle;
                    else
                        istart = istart+imiddle;
                }
                if (pfW2b[istart] > fcurrent)
                    icurrent = istart;
                else
                    icurrent = iend;
                
                // shifting
                for(i3=iNbNeighToSort-2; i3>=icurrent; i3--)
                {
                    SWAP(pfW2b[i3],pfW2b[i3+1],fTmp);
                    SWAP(pidxb[i3],pidxb[i3+1],iTmp);
                    SWAP(pidyb[i3],pidyb[i3+1],iTmp);
                }
                
                // new value
                pfW2b[icurrent] = fcurrent;
                pidxb[icurrent] = pidx[i2];
                pidyb[icurrent] = pidy[i2];
                
            }
        } // end for (i2=0; i2< isqw2; i2++)
        
        
        // 4 neighbors
        if ( iIncludeCloseNeigh==YES )
        {
            icurrent = 0;
            idx = 0; idy = 0; pfW2b[icurrent] = pfW2b[1+4];
            pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;
            idx = 1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = -1; idy = 0;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = 1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy; icurrent++;}
            idx = 0; idy = -1;
            if ( ix+idx>=0 && ix+idx<iNx && iy+idy>=0 && iy+idy<iNy )
            { pfW2b[icurrent] = pfWe[XWe(ix,iy,idx+iw2,idy+iw2)]; pidxb[icurrent] = idx; pidyb[icurrent] = idy;}
            else
            { pfW2b[icurrent] = 1024.0; pidxb[icurrent] = 0; pidyb[icurrent] = 0;}
        }
        else
            pfW2b[0] = pfW2b[1];
        
        // compute W
        if ( EXP(-pfW2b[0]/fh)>0.2 ) iIsolatedPt = 0; else iIsolatedPt = 1;
        for (i=0; i< iNbNeigh; i++)
        {
            idx = pidxb[i];
            idy = pidyb[i];
            iXd = Xd(idx,idy);
            if ( psId[iXd]==0 )
            {
                 i1a = XW(ix,iy,2*i);
                 i1b = XW(ix,iy,2*i+1);
                 if (iIsolatedPt==0) pfW[i1a] = EXP(-pfW2b[i]/fh); else pfW[i1a] = 0.2;
                 pfW[i1b] = SQRT(pfW[i1a]);
                 piY[i1a] = ix+idx;
                 piY[i1b] = iy+idy;
                
          
                }
            } // end for (i=0; i< iNbNeigh; i++)
        } // END
    
  
    
  
    for (iy=0; iy< iNy; iy++)
       for(ix=0; ix< iNx; ix++)
            {
                fWSum = 0.0;
                for (i=0; i< iNbNeigh; i++)
                {
                    fWSum += pfW[XW(ix,iy,2*i)];                
                } 
               for (i=0; i<iNbNeigh; i++)
                {
                    pfW[XW(ix,iy,2*i)]/=(fWSum+EPS);
                    pfW[XW(ix,iy,2*i+1)]=SQRT(pfW[XW(ix,iy,2*i)]);
                }
              }
   
    
  
    free( (float *) pfW2 );
    free( (float *) pfW2b );
    free( (int *) pidx );
    free( (int *) pidy );
    free( (int *) pidxb );
    free( (int *) pidyb );
    free( (short *) psId );
    free( (float *) pfIm0e );
    free( (float *) pfWe );
}







