% This is code for Block nonlocal TV.
close all;clear all;

YES = 0;
NO = 1;

[Im0,map] = imread('images/house.png'); 
[Nx,Ny] = size(Im0); % image size
Im0 = double(Im0)/255;  % normalize image
sigma= 80; % noise level.
k=sigma/255;
randn('seed',0);
ImOrig = Im0; 
Im0 = Im0 + k*randn(size(Im0)); % add noise


% parameters for Weight function. Different levels of noise should adjust
% these parameters.
m = 7; % patch size. May chose as 5-11.
w = 13; % window search size
h = (0.25)^2; % scale parameter for weight function
NbNeigh = 10; % number of neighbors
includeCloseNeigh = NO; % include 4 closest neighbors


% parameters for ALM-BNLTV. Different levels of noise should adjust
% these parameters.
lambda = 1.8 ; %  For heavy noise, the value should be larger
etaInv = 0.1; %  
eta = 1/etaInv;
nbIters = 2; % number of outer iterations
NbInnerIter = 1; % number of inner iterations
VecParametersW = [ Nx; Ny; m; w; h; NbNeigh; includeCloseNeigh;eta];
VecParametersBNLTV = [ Nx; Ny; m; w; NbNeigh; eta; lambda;...
    nbIters; NbInnerIter; includeCloseNeigh;];

G=fspecial('gaussian',[m,m],3);
G=G./sum(G(:)); % normalization

G1=fspecial('gaussian',[m,m],3);
G1=G1./sum(G1(:)); % normalization

% other parameters
cpt_fig = 0; % figure number


NbNeigh2 = VecParametersBNLTV(5);
includeCloseNeigh2 = VecParametersBNLTV(10);
if includeCloseNeigh2==YES; i=4; else; i=0; end

%initial values
q = zeros(Nx,Ny,(NbNeigh2+i),m*m);
d = zeros(Nx,Ny,(NbNeigh2+i),m*m);
u_new=Im0;
W=repmat(0,[Nx,Ny,2*(NbNeigh2+i)]);
Y=W;
u_old=Im0;

for iter=1:10
%weight updating 
disp(['iteration ' num2str(iter) ':']);
tic;
disp(['Weight updating...']);
[W,Y] = WeightsUpdate_nonsys_mex(single(u_new),...
    single(VecParametersW),single(G));

%{
[W,Y] = WeightsUpdate_sys_mex(single(u_new),...
    single(VecParametersW),single(G));
%}    
%{
    [W,Y] = WeightsUpdateBNLTV_mex(single(u_new),...
    single(VecParametersW),single(G),single(W),single(Y),single(q),single(d));
 %}

% ALM for BNLTV
disp(['ALM for BNLTV...']);
[u_new,q,d] = BNLTV_ALM_mex(single(u_new),single(q),single(d),...
    single(Im0),single(W),int32(Y),single(G1),single(VecParametersBNLTV));

t(iter)=toc;

% Compute PSNR
var_u_uRef = mean((u_new(:)-ImOrig(:)).^2);
PSNR(iter)=10*log10(1/var_u_uRef );
disp(['PSNR: ' num2str(PSNR(iter))]);


%error(iter)=sum((u_new(:)-ImOrig(:)).^2);
error1=sum((u_new(:)-u_old(:)).^2);
var_u=sum((u_old(:)).^2);
if error1/var_u<5e-5
    break;
end
u_old=u_new;

cpt_fig = cpt_fig + 1;
figure(cpt_fig); 
subplot(1,2,1); imshow(Im0,[]);  title('Im0');
subplot(1,2,2); imshow(u_new,[]); title(['u, PSNR=',num2str(PSNR(iter))]);
drawnow;
end

figure,plot(PSNR,'ro-'); title('PSNR & iteration');





