
// mex BNLTV_mex.c


#include <stdio.h>
#include <stdlib.h>
#include <mex.h>
#include <math.h>


 
#define YES 0
#define NO 1

#define X(ixX,iyX)   (iyX)*iNx+ (ixX)
#define XW(ixX,iyX,i)   (i)*iNxy+(iyX)* iNx+(ixX)
#define XG(ixZ,iyZ)  (iyZ+im2)*im+(ixZ+im2)
#define XD(ixX,iyX,i,ixZ,iyZ)  (iyZ+im2)*iNxybm+(ixZ+im2)*iNxyb+(i)*iNxy+(iyX)*iNx+(ixX)    

#define SQR(x) (x)*(x)



float SQRT(float number) {
    long i;
    float x, y;
    const float f = 1.5F;
    
    x = number * 0.5F;
    y  = number;
    i  = * ( long * ) &y;
    i  = 0x5f3759df - ( i >> 1 );
    y  = * ( float * ) &i;
    y  = y * ( f - ( x * y * y ) );
    y  = y * ( f - ( x * y * y ) );
    return number * y;
}











/****************************************/
extern void mexFunction(int iNbOut, mxArray *pmxOut[],
int iNbIn, const mxArray *pmxIn[])
{
    
  /* iNbOut: number of outputs
     pmxOut: array of pointers to output arguments */
    
  /* iNbIn: number of inputs
     pmxIn: array of pointers to input arguments */
    
    
    float   *pfIm0, *pfu, *pfuNew, *pfVecGeneralParameters, *pfW;
    float   fEta, fLambda, fw1,fw2;
    float   fqij, fqji;
    float   *pfq, *pfqNew, fEtaInv, fSum1, fSum2, fDivWD, fDen, fNormU, fTemp;
    float   fSqrtw1, fSqrtw2, fGuij;
    float   *pfd, *pfdNew, fdij, fdji;
    float    *pfG;
    float    fg,fSqrtg;
    int     iNy, iNx, iNdim, iDim[3],iDim1[4];
    int     iNbNeigh, im, im2, iw, iw2;
    int     ixX, iyX, ixY, iyY,ixZ,iyZ, ixYpZ,iyYpZ,ixXsZ,iyXsZ,ixXpZ,iyXpZ;
    int     i, j, i1, i2;
    int     iNbIters, iIter;
    
    int     *piY, iNxy, iNxyb,iNxybm;
    int     iIterU, iNbInnerIter, iIncludeCloseNeigh;
    int     isqm2;
          
    pfu = mxGetData(pmxIn[0]);
    
    pfq = mxGetData(pmxIn[1]);
    
    pfd = mxGetData(pmxIn[2]);
    
    pfIm0 = mxGetData(pmxIn[3]);
    
    pfW = mxGetData(pmxIn[4]);
    
    piY = mxGetData(pmxIn[5]);
        
    pfG  = mxGetData(pmxIn[6]);
    
    pfVecGeneralParameters = mxGetData(pmxIn[7]);
    
    
  /* Get the displaying's indicator of different messages, values, etc */
    iNx = (int) pfVecGeneralParameters[0];
    iNy = (int) pfVecGeneralParameters[1];
    im = (int) pfVecGeneralParameters[2];
    iw = (int) pfVecGeneralParameters[3];
    iNbNeigh = (int) pfVecGeneralParameters[4];
    fEta = pfVecGeneralParameters[5];
    fLambda = pfVecGeneralParameters[6];
    iNbIters = (int) pfVecGeneralParameters[7];
    iNbInnerIter = (int) pfVecGeneralParameters[8];
    iIncludeCloseNeigh = (int) pfVecGeneralParameters[9];
        
    if (iNbNeigh>iw*iw-4)
    {
        iNbNeigh = iw*iw;
        iIncludeCloseNeigh = NO;
    }
    else
        if ( iIncludeCloseNeigh==YES ) iNbNeigh += 4;
    
    
    im2 = (im-1)/2;
    iw2 = (iw-1)/2;
    
    iNxy = iNx* iNy;
    iNxyb=iNxy*iNbNeigh;
    iNxybm=iNxyb*im;
    isqm2 = im*im;
    
    fEtaInv = 1.0f/ fEta;
    
   //Output  
    
    iNdim = 2;
    iDim[0] = iNx;
    iDim[1] = iNy;
    
    pmxOut[0] = mxCreateNumericArray(iNdim,(const int*)iDim,mxSINGLE_CLASS,mxREAL);
    pfuNew = mxGetData(pmxOut[0]);
    
    
    iNdim = 4;
    iDim1[0] = iNx;
    iDim1[1] = iNy;
    iDim1[2] = iNbNeigh;
    iDim1[3] =isqm2;
    
    pmxOut[1] = mxCreateNumericArray(iNdim,(const int*)iDim1,mxSINGLE_CLASS,mxREAL);
    pfqNew = mxGetData(pmxOut[1]);
    
    pmxOut[2] = mxCreateNumericArray(iNdim,(const int*)iDim1,mxSINGLE_CLASS,mxREAL);
    pfdNew = mxGetData(pmxOut[2]);
       
    
    
    
   
    
    // init
    for (i=0; i< iNxy; i++)
    {
        pfuNew[i] = pfu[i];
        
        for (i1=0; i1< iNbNeigh; i1++) 
            for (i2=0;i2<isqm2;i2++)
              { pfqNew[(i*iNbNeigh+i1)*isqm2+i2] = pfq[(i*iNbNeigh+i1)*isqm2+i2]; 
                 pfdNew[(i*iNbNeigh+i1)*isqm2+i2] = pfd[(i*iNbNeigh+i1)*isqm2+i2]; 
               }
    }

    
    
    
    // iterations
    for (iIter=0; iIter< iNbIters; iIter++)
    {
        
        // u
        for (iIterU=0; iIterU< iNbInnerIter; iIterU++)
        {
            for (iyX=0; iyX< iNy; iyX++)
                for(ixX=0; ixX< iNx; ixX++)     
               {
                     fSum1 = 0.0f;
                     fSum2 = 0.0f;
                     fDivWD = 0.0f;
                    
                    for (iyZ=-im2;iyZ<=im2;iyZ++)
                        for (ixZ=-im2;ixZ<=im2;ixZ++)
                        {
                            ixXsZ=ixX-ixZ; //X-Z
                            if (ixXsZ<0)  ixXsZ=-ixXsZ;
                            if (ixXsZ>=iNx) ixXsZ=2*iNx-2-ixXsZ;
                            iyXsZ=iyX-iyZ;
                            if (iyXsZ<0)  iyXsZ=-iyXsZ;
                            if (iyXsZ>=iNy) iyXsZ=2*iNy-2-iyXsZ;
                            fg=pfG[XG(ixZ,iyZ)];// g(Z)
                            fSqrtg=SQRT(fg);
                           for (i=0; i<iNbNeigh; i++)
                           {
                                ixY = piY[XW(ixXsZ,iyXsZ,2*i)];
                                iyY = piY[XW(ixXsZ,iyXsZ,2*i+1)];
                                ixYpZ = ixY+ixZ; //Y+Z
                                if (ixYpZ<0)  ixYpZ=-ixYpZ;
                                if (ixYpZ>=iNx) ixYpZ=2*iNx-2-ixYpZ; 
                                iyYpZ = iyY+iyZ;
                                if (iyYpZ<0)  iyYpZ=-iyYpZ;
                                if (iyYpZ>=iNy) iyYpZ=2*iNy-2-iyYpZ; 
                                fw1=0.0f;
                                fSqrtw1=0.0f;
                                fqji=0.0f;
                                fdji=0.0f;
                                for (j=0;j<iNbNeigh;j++)  //W(Y,X-Z)
                               {
                                   if (piY[XW(ixY,iyY,2*j)]==ixXsZ && piY[XW(ixY,iyY,2*j+1)]==iyXsZ)
                                  {
                                     fw1=pfW[XW(ixY,iyY,2*j)]; //W(Y,X-Z)
                                     fSqrtw1=pfW[XW(ixY,iyY,2*j+1)];
                                     fqji = pfqNew[XD(ixY,iyY,j,ixZ,iyZ)];
                                     fdji = pfdNew[XD(ixY,iyY,j,ixZ,iyZ)];
                                     break;   
                                  }
                             
                              }   
                              fw2 = pfW[XW(ixXsZ,iyXsZ,2*i)]+fw1; //W(X-Z,Y)+W(Y,X-Z)
                              fSqrtw2 = pfW[XW(ixXsZ,iyXsZ,2*i+1)];
                              
                              fqij = pfqNew[XD(ixXsZ,iyXsZ,i,ixZ,iyZ)];
                              fdij = pfdNew[XD(ixXsZ,iyXsZ,i,ixZ,iyZ)];
                              
                              fDivWD+= fSqrtw1*( fdji-fqji )*fSqrtg;
                              fDivWD+= fSqrtw2*(fqij-fdij)*fSqrtg;
                              
                              fSum1 += fw2*fg;
                              fSum2 += fw2* pfuNew[X(ixYpZ,iyYpZ)]*fg;
                              
                        
                          } // end for i
                
                     }//end for ixZ,iyZ;
                   fDen = fLambda + fEta*fSum1; 
                   pfuNew[X(ixX,iyX)] = (fEta*fSum2 + fLambda*pfIm0[X(ixX,iyX)] - fEta*fDivWD)/ fDen;
                
                } // end for iyX,ixX
            
        } // end for (iIterU=0; iIterU< iNbInnerIter-1; iIterU++)
        
        
         // q
        for (iyX=0; iyX< iNy; iyX++)
            for(ixX=0; ixX< iNx; ixX++)
           {
                 fNormU = 0.0f;
                 for (iyZ=-im2;iyZ<=im2;iyZ++)
                        for (ixZ=-im2;ixZ<=im2;ixZ++)
                        {
                           ixXpZ=ixX+ixZ; //X+Z
                           if (ixXpZ<0)  ixXpZ=-ixXpZ;
                           if (ixXpZ>=iNx) ixXpZ=2*iNx-2-ixXpZ;
                           iyXpZ=iyX+iyZ;
                           if (iyXpZ<0)  iyXpZ=-iyXpZ;
                           if (iyXpZ>=iNy) iyXpZ=2*iNy-2-iyXpZ;
                            fg=pfG[XG(ixZ,iyZ)];// g(Z)
                            fSqrtg=SQRT(fg);
            
                        for (i=0; i<iNbNeigh; i++)
                       {
                           ixY = piY[XW(ixX,iyX,2*i)];
                           iyY = piY[XW(ixX,iyX,2*i+1)];
                           ixYpZ = ixY+ixZ; //Y+Z
                           if (ixYpZ<0)  ixYpZ=-ixYpZ;
                           if (ixYpZ>=iNx) ixYpZ=2*iNx-2-ixYpZ; 
                           iyYpZ = iyY+iyZ;
                           if (iyYpZ<0)  iyYpZ=-iyYpZ;
                           if (iyYpZ>=iNy) iyYpZ=2*iNy-2-iyYpZ; 
                           fSqrtw2 = pfW[XW(ixX,iyX,2*i+1)];
                           fdij = pfdNew[XD(ixX,iyX,i,ixZ,iyZ)];
                           fGuij = fSqrtw2* (pfuNew[X(ixYpZ,iyYpZ)]-pfuNew[X(ixXpZ,iyXpZ)])*fSqrtg;
                           fNormU += SQR(fGuij+fdij);
                           pfqNew[XD(ixX,iyX,i,ixZ,iyZ)] = fGuij+ fdij;
                      }
                }
            
            fNormU = SQRT(fNormU);
            if ( fNormU<fEtaInv )
                for (iyZ=-im2;iyZ<=im2;iyZ++)
                        for (ixZ=-im2;ixZ<=im2;ixZ++)
                           for (i=0; i<iNbNeigh; i++)
                              pfqNew[XD(ixX,iyX,i,ixZ,iyZ)] = 0.0f;
            else
            {
                fTemp = fNormU-fEtaInv; fTemp /= fNormU;
                for (iyZ=-im2;iyZ<=im2;iyZ++)
                        for (ixZ=-im2;ixZ<=im2;ixZ++)
                            for (i=0; i<iNbNeigh; i++)
                                  pfqNew[XD(ixX,iyX,i,ixZ,iyZ)]*= fTemp;
            }
                        
        }//end for (iyX=0; iyX< iNy; iyX++)
        
        
          // d 
        for (iyX=0; iyX< iNy; iyX++)
            for(ixX=0; ixX< iNx; ixX++)
           {
             for (iyZ=-im2;iyZ<=im2;iyZ++)
                        for (ixZ=-im2;ixZ<=im2;ixZ++)
                        {
                           ixXpZ=ixX+ixZ; //X+Z
                           if (ixXpZ<0)  ixXpZ=-ixXpZ;
                           if (ixXpZ>=iNx) ixXpZ=2*iNx-2-ixXpZ;
                           iyXpZ=iyX+iyZ;
                           if (iyXpZ<0)  iyXpZ=-iyXpZ;
                           if (iyXpZ>=iNy) iyXpZ=2*iNy-2-iyXpZ;
                            fg=pfG[XG(ixZ,iyZ)];// g(Z)
                            fSqrtg=SQRT(fg);
                          for (i=0; i<iNbNeigh; i++)
                          {
                                ixY = piY[XW(ixX,iyX,2*i)]; //Y
                                iyY = piY[XW(ixX,iyX,2*i+1)];
                                ixYpZ = ixY+ixZ; //Y+Z
                                if (ixYpZ<0)  ixYpZ=-ixYpZ;
                                if (ixYpZ>=iNx) ixYpZ=2*iNx-2-ixYpZ; 
                                iyYpZ = iyY+iyZ;
                                if (iyYpZ<0)  iyYpZ=-iyYpZ;
                                if (iyYpZ>=iNy) iyYpZ=2*iNy-2-iyYpZ; 
                                
                                
                               fSqrtw2 = pfW[XW(ixX,iyX,2*i+1)];
                               fGuij = fSqrtw2* (pfuNew[X(ixYpZ,iyYpZ)]-pfuNew[X(ixXpZ,iyXpZ)])*fSqrtg;                                      
                               pfdNew[XD(ixX,iyX,i,ixZ,iyZ)] += (fGuij - pfqNew[XD(ixX,iyX,i,ixZ,iyZ)]);
                          } // end for i
                  }//end for ixZ,iyZ;
        } // end for iyX,ixX
        
    
        
       
    } // END for (iIter=0; iIter< iNbIters; iIter++)
   

}
/****************************************/






/**************************************** End of file ****************************************/
