function  par=Par_initial(sigma)

par.sigma      =   sigma;                                 % Variance of the noise image
par.SearchWin =   30;                                   % Non-local patch searching window
par.eta     =   9;                                  % Parameter \eta
par.delta  =1e-2;                                  % time step 
par.Innerloop =   2;                                    % blockmatching
par.mu=0.2;
par.coe=1.0;
par.thresh=10;
if     sigma==10
    par.patsize      =6;
    par.patnum        =40;
    par.Iter          =15;
    par.lamada        =0.54;
    par.mu            =0.1;
elseif sigma==20
    par.patsize       =   6;                            % Patch size
    par.patnum        =   40;                           % Initial Non-local Patch number
    par.Iter          =   18;                            % total iter numbers
    par.lamada        =   0.54;                         % Noise estimete parameter
    par.mu            =   0.1;
elseif sigma == 30
    par.patsize       =   7;
    par.patnum        =   50;
    par.Iter          =   18;
    par.lamada        =   0.56; 
elseif sigma==50
    par.patsize       =   8;
    par.patnum        =   60;
    par.Iter          =   20;
    par.lamada        =   0.58; 
    par.thresh        =   2;
    
elseif sigma==75
    par.patsize       =   8;
    par.patnum        =   70;
    par.Iter          =   22;  
    par.lamada        =   0.58;
    par.thresh        =   2;

else
    par.patsize       =   9;
    par.patnum        =   90;
    par.Iter          =   25;
    par.lamada        =   0.58; 
    par.thresh        =   2;

end

par.step      =  floor((par.patsize)/2-1);      %step size of the slidding window. 