function  [Pat_g_hat,Pat_f,SigmaArr]  =  Im2Patch( g_hat,g, f, par)
TotalPatNum = (size(g_hat,1)-par.patsize+1)*(size(g_hat,2)-par.patsize+1);                  %Total Patch Number in the image
Pat_g_hat           =   zeros(par.patsize*par.patsize, TotalPatNum, 'single');                      %Patches of g_hat
Pat_f    =   zeros(par.patsize*par.patsize, TotalPatNum, 'single');  
Pat_g         =   zeros(par.patsize*par.patsize, TotalPatNum, 'single');                      %Patches of the noisy image
k           =   0;

for j  = 1:par.patsize
    for i  = 1:par.patsize
              k     =  k+1;
        E_patch     =  g_hat(i:end-par.patsize+i,j:end-par.patsize+j);
        N_patch     =  g(i:end-par.patsize+i,j:end-par.patsize+j);   
        O_patch   =  f(i:end-par.patsize+i,j:end-par.patsize+j);   
        Pat_g_hat(k,:)      =  E_patch(:)';
        Pat_g(k,:)    =  N_patch(:)';
        Pat_f(k,:)  = O_patch(:)';
    end
end
 SigmaArr = par.lamada*sqrt(abs(repmat(par.sigma^2,1,size(Pat_g_hat,2))-mean((Pat_g-Pat_g_hat).^2)));          %Estimated Local Noise Level