  clc;clear;
 imagefilename={'peppers256.png','Monarch.png','Cameraman256.png','montage.png','square.bmp',...
                           'house.png','barbara.png','boat.png','Lena512.png','hill.png'};
 %imagenum=7;
 
   sigma  = 100;    

   for imagenum=4:4
   Ima_ori = double(imread(['images/' imagefilename{imagenum}])); 
   %Generate noisy image
    randn('seed', 0);
    Ima_noi = Ima_ori + sigma* randn(size(Ima_ori));     
    PSNR0  =  computePSNR(Ima_ori, Ima_noi);
    fprintf( 'Sigma = %2.3f, Noisy Image PSNR = %2.2f \n', sigma, PSNR0 );
    
    Par   = Par_initial(sigma);  
    if imagenum==5 & Par.sigma<=40
        Par.thresh=2;
    end
    
    
    Ima_extnoi=padarray(Ima_noi,[Par.patsize-1 Par.patsize-1], 'post','symmetric');
   fprintf( 'Iteration is starting...\n' );
   [f_ext,D] = BMLSVDTV( Ima_extnoi, Ima_ori, Par );
   
    f=f_ext(1:end-Par.patsize+1,1:end-Par.patsize+1);
    PSNR(imagenum)  = computePSNR(f,Ima_ori);
    
    fprintf( ['%d:' imagefilename{imagenum} ' The fininal PSNR = %2.2f \n\n'], imagenum,PSNR(imagenum) );
    imshow(uint8(f));
    
    result(imagenum).D=D;
    result(imagenum).f_ext=f_ext;
    result(imagenum).Par=Par;
    result(imagenum).PSNR=PSNR;
    result(imagenum).PSNR0=PSNR0;
    result(imagenum).Ima_noi=Ima_noi;
    result(imagenum).filename=imagefilename{imagenum};
     
   end
   close all;
   figure,
   subplot(121),imshow(uint8(Ima_noi));title(['Noisy, PSNR=' num2str(PSNR0)]);
   subplot(122),imshow(uint8(f));title(['Restored, PSNR=' num2str(PSNR(imagenum))]);
   %save (['result_' num2str(sigma) '.mat'],'result');